/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.rest.resource.attachments;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sw360.clients.rest.resource.LinkObjects;
import org.eclipse.sw360.clients.rest.resource.SW360HalResourceUtility;
import org.eclipse.sw360.clients.rest.resource.SW360SimpleHalResource;
import org.eclipse.sw360.clients.rest.resource.attachments.SW360AttachmentType;

public final class SW360SparseAttachment
extends SW360SimpleHalResource {
    private String filename;
    private SW360AttachmentType attachmentType;
    private String sha1;

    public String getFilename() {
        return this.filename;
    }

    public SW360SparseAttachment setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public SW360AttachmentType getAttachmentType() {
        return this.attachmentType;
    }

    public SW360SparseAttachment setAttachmentType(SW360AttachmentType attachmentType) {
        this.attachmentType = attachmentType;
        return this;
    }

    public String getSha1() {
        return this.sha1;
    }

    public SW360SparseAttachment setSha1(String sha1) {
        this.sha1 = sha1;
        return this;
    }

    @JsonIgnore
    public String getAttachmentId() {
        return Optional.ofNullable(this.getLinks()).map(LinkObjects::getSelf).flatMap(SW360HalResourceUtility::getLastIndexOfSelfLink).orElse("");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SW360SparseAttachment) || !super.equals(o)) {
            return false;
        }
        SW360SparseAttachment that = (SW360SparseAttachment)o;
        return Objects.equals(this.filename, that.filename) && Objects.equals((Object)this.attachmentType, (Object)that.attachmentType) && Objects.equals(this.sha1, that.sha1);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.filename, this.attachmentType, this.sha1});
    }

    @Override
    public boolean canEqual(Object o) {
        return o instanceof SW360SparseAttachment;
    }
}

