/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.rest.resource.projects;

import java.util.Objects;
import org.eclipse.sw360.clients.rest.resource.projects.SW360ProjectType;

public final class ProjectSearchParams {
    public static final ProjectSearchParams ALL_PROJECTS = ProjectSearchParams.builder().build();
    private final String name;
    private final SW360ProjectType type;
    private final String businessUnit;
    private final String tag;

    private ProjectSearchParams(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.businessUnit = builder.businessUnit;
        this.tag = builder.tag;
    }

    public String getName() {
        return this.name;
    }

    public SW360ProjectType getType() {
        return this.type;
    }

    public String getBusinessUnit() {
        return this.businessUnit;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectSearchParams params = (ProjectSearchParams)o;
        return Objects.equals(this.getName(), params.getName()) && this.getType() == params.getType() && Objects.equals(this.getBusinessUnit(), params.getBusinessUnit()) && Objects.equals(this.getTag(), params.getTag());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getType(), this.getBusinessUnit(), this.getTag()});
    }

    public String toString() {
        return "ProjectSearchParams{name='" + this.name + "', type=" + String.valueOf((Object)this.type) + ", businessUnit='" + this.businessUnit + "', tag='" + this.tag + "'}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private SW360ProjectType type;
        private String businessUnit;
        private String tag;

        private Builder() {
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withType(SW360ProjectType type) {
            this.type = type;
            return this;
        }

        public Builder withBusinessUnit(String unit) {
            this.businessUnit = unit;
            return this;
        }

        public Builder withTag(String tag) {
            this.tag = tag;
            return this;
        }

        public ProjectSearchParams build() {
            return new ProjectSearchParams(this);
        }
    }
}

