/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.adapter;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.sw360.clients.rest.resource.components.SW360Component;
import org.eclipse.sw360.clients.rest.resource.components.SW360ComponentType;
import org.eclipse.sw360.clients.rest.resource.releases.SW360Release;

public class SW360ComponentAdapterUtils {
    private SW360ComponentAdapterUtils() {
    }

    public static void setComponentType(SW360Component component, boolean isProprietary) {
        if (isProprietary) {
            component.setComponentType(SW360ComponentType.INTERNAL);
        } else {
            component.setComponentType(SW360ComponentType.OSS);
        }
    }

    static SW360Component createFromRelease(SW360Release release) {
        SW360Component sw360Component = new SW360Component();
        sw360Component.setName(release.getName());
        SW360ComponentAdapterUtils.setComponentType(sw360Component, release.isProprietary());
        sw360Component.setCategories(Collections.singleton("Antenna"));
        sw360Component.setHomepage(release.getHomepageUrl());
        return sw360Component;
    }

    static SW360Component validateComponent(SW360Component component) {
        if (StringUtils.isEmpty((CharSequence)component.getName())) {
            throw new IllegalArgumentException("Invalid component: missing property 'name'.");
        }
        if (component.getCategories() == null || component.getCategories().isEmpty()) {
            throw new IllegalArgumentException("Invalid component: missing property 'categories'.");
        }
        return component;
    }
}

