/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.adapter;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.sw360.clients.adapter.SW360LicenseClientAdapterAsync;
import org.eclipse.sw360.clients.rest.SW360LicenseClient;
import org.eclipse.sw360.clients.rest.resource.licenses.SW360License;
import org.eclipse.sw360.clients.rest.resource.licenses.SW360SparseLicense;
import org.eclipse.sw360.clients.utils.FutureUtils;

class SW360LicenseClientAdapterAsyncImpl
implements SW360LicenseClientAdapterAsync {
    private final SW360LicenseClient licenseClient;

    public SW360LicenseClientAdapterAsyncImpl(SW360LicenseClient client) {
        this.licenseClient = client;
    }

    @Override
    public SW360LicenseClient getLicenseClient() {
        return this.licenseClient;
    }

    @Override
    public CompletableFuture<List<SW360SparseLicense>> getLicenses() {
        return this.getLicenseClient().getLicenses();
    }

    @Override
    public CompletableFuture<Optional<SW360License>> getLicenseByName(String license) {
        return FutureUtils.optionalFuture(this.getLicenseClient().getLicenseByName(license));
    }

    @Override
    public CompletableFuture<SW360License> enrichSparseLicense(SW360SparseLicense sparseLicense) {
        return this.getLicenseClient().getLicenseByName(sparseLicense.getShortName());
    }

    @Override
    public CompletableFuture<SW360License> createLicense(SW360License license) {
        return this.getLicenseClient().createLicense(license);
    }

    @Override
    public CompletableFuture<Integer> deleteLicense(String licenseId) {
        return this.getLicenseClient().deleteLicense(licenseId);
    }
}

