/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.adapter;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.sw360.clients.rest.resource.vulnerabilities.SW360CVEReference;
import org.eclipse.sw360.clients.rest.resource.vulnerabilities.SW360ReleaseVulnerabilityRelation;
import org.eclipse.sw360.clients.rest.resource.vulnerabilities.SW360VendorAdvisory;
import org.eclipse.sw360.clients.rest.resource.vulnerabilities.SW360VerificationStateInfo;
import org.eclipse.sw360.clients.rest.resource.vulnerabilities.SW360Vulnerability;

class SW360VulnerabilityAdapterUtils {
    private SW360VulnerabilityAdapterUtils() {
    }

    public static SW360Vulnerability validateVulnerability(SW360Vulnerability vulnerability) {
        if (StringUtils.isBlank((CharSequence)vulnerability.getExternalId())) {
            throw new IllegalArgumentException("Invalid vulnerability: missing property 'externalId'.");
        }
        if (vulnerability.getCveReferences() != null) {
            vulnerability.getCveReferences().stream().forEach(SW360VulnerabilityAdapterUtils::validateCVEReference);
        }
        if (vulnerability.getVendorAdvisories() != null) {
            vulnerability.getVendorAdvisories().stream().forEach(SW360VulnerabilityAdapterUtils::validateVendorAdvisory);
        }
        return vulnerability;
    }

    public static SW360ReleaseVulnerabilityRelation validateReleaseVulnerabilityRelation(SW360ReleaseVulnerabilityRelation sw360ReleaseVulnerabilityRelation) {
        if (StringUtils.isBlank((CharSequence)sw360ReleaseVulnerabilityRelation.getReleaseId())) {
            throw new IllegalArgumentException("Invalid ReleaseVulnerabilityRelation: missing property 'releaseId'.");
        }
        if (sw360ReleaseVulnerabilityRelation.getVerificationStateInfo() != null) {
            sw360ReleaseVulnerabilityRelation.getVerificationStateInfo().stream().forEach(SW360VulnerabilityAdapterUtils::validateVerificationStateInfo);
        }
        return sw360ReleaseVulnerabilityRelation;
    }

    private static SW360VerificationStateInfo validateVerificationStateInfo(SW360VerificationStateInfo sw360VerificationStateInfo) {
        if (StringUtils.isBlank((CharSequence)sw360VerificationStateInfo.getCheckedBy())) {
            throw new IllegalArgumentException("Invalid VerificationStateInfo: missing property 'checkedBy'.");
        }
        if (StringUtils.isBlank((CharSequence)sw360VerificationStateInfo.getCheckedOn())) {
            throw new IllegalArgumentException("Invalid VerificationStateInfo: missing property 'checkedOn'.");
        }
        if (sw360VerificationStateInfo.getVerificationState() == null) {
            throw new IllegalArgumentException("Invalid VerificationStateInfo: missing property 'verificationState'.");
        }
        return sw360VerificationStateInfo;
    }

    private static SW360CVEReference validateCVEReference(SW360CVEReference sw360CVEReference) {
        if (StringUtils.isBlank((CharSequence)sw360CVEReference.getYear())) {
            throw new IllegalArgumentException("Invalid CVEReference: missing property 'year'.");
        }
        try {
            int year = Integer.parseInt(sw360CVEReference.getYear());
            if (year <= 0) {
                throw new IllegalArgumentException("Invalid CVEReference: property 'year' should be a valid year.");
            }
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid CVEReference: property 'year' should be a valid year.");
        }
        if (StringUtils.isBlank((CharSequence)sw360CVEReference.getNumber())) {
            throw new IllegalArgumentException("Invalid CVEReference: missing property 'number'.");
        }
        try {
            Integer.parseInt(sw360CVEReference.getNumber());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid CVEReference: property 'number' should be a valid number.");
        }
        return sw360CVEReference;
    }

    private static SW360VendorAdvisory validateVendorAdvisory(SW360VendorAdvisory sw360VendorAdvisory) {
        if (StringUtils.isBlank((CharSequence)sw360VendorAdvisory.getVendor())) {
            throw new IllegalArgumentException("Invalid VendorAdvisory: missing property 'vendor'.");
        }
        if (StringUtils.isBlank((CharSequence)sw360VendorAdvisory.getName())) {
            throw new IllegalArgumentException("Invalid VendorAdvisory: missing property 'name'.");
        }
        if (StringUtils.isBlank((CharSequence)sw360VendorAdvisory.getUrl())) {
            throw new IllegalArgumentException("Invalid VendorAdvisory: missing property 'url'.");
        }
        return sw360VendorAdvisory;
    }
}

