/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.adapter;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.sw360.clients.adapter.SW360VulnerabilityAdapterUtils;
import org.eclipse.sw360.clients.adapter.SW360VulnerabilityClientAdapterAsync;
import org.eclipse.sw360.clients.rest.SW360VulnerabilityClient;
import org.eclipse.sw360.clients.rest.resource.vulnerabilities.SW360ReleaseVulnerabilityRelation;
import org.eclipse.sw360.clients.rest.resource.vulnerabilities.SW360Vulnerability;
import org.eclipse.sw360.clients.utils.FutureUtils;

class SW360VulnerabilityClientAdapterAsyncImpl
implements SW360VulnerabilityClientAdapterAsync {
    private final SW360VulnerabilityClient vulnerabilityClient;

    public SW360VulnerabilityClientAdapterAsyncImpl(SW360VulnerabilityClient client) {
        this.vulnerabilityClient = client;
    }

    @Override
    public SW360VulnerabilityClient getVulnerabilityClient() {
        return this.vulnerabilityClient;
    }

    @Override
    public CompletableFuture<Optional<SW360Vulnerability>> getVulnerabilityByExternalId(String externalId) {
        return FutureUtils.optionalFuture(this.getVulnerabilityClient().getVulnerabilityByExternalId(externalId));
    }

    @Override
    public CompletableFuture<List<SW360Vulnerability>> getVulnerabilities() {
        return this.getVulnerabilityClient().getVulnerabilities();
    }

    @Override
    public CompletableFuture<SW360Vulnerability> createVulnerability(SW360Vulnerability vulnerability) {
        return FutureUtils.wrapInFuture(() -> {
            if (vulnerability.getId() != null) {
                throw new IllegalArgumentException("Vulnerability already has the id " + vulnerability.getId());
            }
            return SW360VulnerabilityAdapterUtils.validateVulnerability(vulnerability);
        }, "Cannot create vulnerability with external Id - " + vulnerability.getExternalId()).thenCompose(this.getVulnerabilityClient()::createVulnerability);
    }

    @Override
    public CompletableFuture<SW360Vulnerability> updateVulnerability(SW360Vulnerability vulnerability, String externalId) {
        return FutureUtils.wrapInFuture(() -> {
            if (StringUtils.isBlank((CharSequence)vulnerability.getExternalId())) {
                throw new IllegalArgumentException("Cannot update vulnerability without external ID");
            }
            return SW360VulnerabilityAdapterUtils.validateVulnerability(vulnerability);
        }, "Cannot update release for " + vulnerability.getExternalId()).thenCompose(vulnerabilityVerified -> this.getVulnerabilityClient().patchVulnerability((SW360Vulnerability)vulnerabilityVerified, externalId));
    }

    @Override
    public CompletableFuture<Integer> deleteVulnerability(String externalId) {
        return this.getVulnerabilityClient().deleteVulnerability(externalId);
    }

    @Override
    public CompletableFuture<SW360ReleaseVulnerabilityRelation> createVulnerabilityReleaseRelation(String externalId, SW360ReleaseVulnerabilityRelation releaseVulnerabilityRelation) {
        return FutureUtils.wrapInFuture(() -> {
            if (StringUtils.isBlank((CharSequence)externalId)) {
                throw new IllegalArgumentException("Cannot create vulnerability release relation without external ID");
            }
            return SW360VulnerabilityAdapterUtils.validateReleaseVulnerabilityRelation(releaseVulnerabilityRelation);
        }, "Cannot create vulnerability release relation with external Id - " + externalId).thenCompose(vulnerablitiValidated -> this.getVulnerabilityClient().createVulnerabilityReleaseRelation(externalId, (SW360ReleaseVulnerabilityRelation)vulnerablitiValidated));
    }

    @Override
    public CompletableFuture<Integer> deleteVulnerabilityReleaseRelation(String externalId, String releaseId) {
        return this.getVulnerabilityClient().deleteVulnerabilityReleaseRelation(externalId, releaseId);
    }
}

