/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.auth;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.eclipse.sw360.clients.auth.AccessToken;
import org.eclipse.sw360.clients.auth.SW360AuthenticationClient;
import org.eclipse.sw360.clients.utils.FutureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenProvider.class);
    private final SW360AuthenticationClient authClient;
    private CompletableFuture<AccessToken> tokenFuture;
    private AccessToken accessToken;

    public AccessTokenProvider(SW360AuthenticationClient authClient) {
        this.authClient = authClient;
    }

    public SW360AuthenticationClient getAuthClient() {
        return this.authClient;
    }

    public <T> CompletableFuture<T> doWithToken(Function<? super AccessToken, ? extends CompletableFuture<T>> func) {
        return this.obtainAccessToken().thenCompose(token -> ((CompletableFuture)func.apply((AccessToken)token)).whenComplete((result, exception) -> this.onRequestComplete((AccessToken)token, (Throwable)exception)));
    }

    protected synchronized CompletableFuture<AccessToken> obtainAccessToken() {
        CompletionStage<AccessToken> result = this.tokenFuture;
        if (this.tokenFuture == null) {
            LOG.debug("Obtaining a new access token for SW360.");
            this.tokenFuture = result = this.getAuthClient().getOAuth2AccessToken().thenApply(AccessToken::new);
            this.tokenFuture.whenComplete(this::handleTokenResult);
        }
        return result;
    }

    protected synchronized void invalidate(AccessToken token) {
        if (token.equals(this.accessToken)) {
            LOG.debug("Invalidating access token for SW360.");
            this.clearCache();
        }
    }

    private synchronized void handleTokenResult(AccessToken token, Throwable error) {
        if (error != null) {
            this.clearCache();
            LOG.warn("Could not obtain an access token for SW360.");
            LOG.debug("Stacktrace:", error);
        } else {
            this.accessToken = token;
        }
    }

    private void onRequestComplete(AccessToken token, Throwable exception) {
        LOG.debug("Request with access token completed. Exception is {}.", (Object)String.valueOf(exception));
        if (FutureUtils.isFailedRequestWithStatus(exception, 401)) {
            this.invalidate(token);
        }
    }

    private void clearCache() {
        this.tokenFuture = null;
        this.accessToken = null;
    }
}

