/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.auth;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.sw360.clients.config.SW360ClientConfig;
import org.eclipse.sw360.http.RequestBuilder;
import org.eclipse.sw360.http.Response;
import org.eclipse.sw360.http.utils.HttpUtils;

public class SW360AuthenticationClient {
    private static final String GRANT_TYPE_VALUE = "password";
    private static final String JSON_TOKEN_KEY = "access_token";
    private static final String FMT_REQUEST_BODY = "%s=%s&%s=%s&%s=%s";
    private static final String TAG = "get_access_token";
    private final SW360ClientConfig clientConfig;

    public SW360AuthenticationClient(SW360ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public SW360ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public CompletableFuture<String> getOAuth2AccessToken() {
        String tokenCheck = this.getClientConfig().getToken();
        if (!StringUtils.isEmpty((CharSequence)tokenCheck)) {
            return CompletableFuture.completedFuture(tokenCheck);
        }
        return this.getClientConfig().getHttpClient().execute(this::initTokenRequest, HttpUtils.checkResponse(this::extractToken, (String)TAG));
    }

    private void initTokenRequest(RequestBuilder builder) {
        builder.uri(this.getClientConfig().getAuthURL()).method(RequestBuilder.Method.POST).header("Authorization", SW360AuthenticationClient.generateBasicAuthHeader(this.getClientConfig().getClientId(), this.getClientConfig().getClientPassword())).body(body -> body.string(this.generateTokenRequestBody(), "application/x-www-form-urlencoded"));
    }

    private String generateTokenRequestBody() {
        return String.format(Locale.ROOT, FMT_REQUEST_BODY, "grant_type", GRANT_TYPE_VALUE, "username", this.getClientConfig().getUser(), GRANT_TYPE_VALUE, this.getClientConfig().getPassword());
    }

    private String extractToken(Response response) throws IOException {
        Map json = (Map)this.getClientConfig().getObjectMapper().readValue(response.bodyStream(), Map.class);
        Object token = json.get(JSON_TOKEN_KEY);
        if (!(token instanceof String)) {
            throw new IOException("Could not extract access token from server response. The attribute 'access_token' is not present or has an unexpected value.");
        }
        return (String)token;
    }

    private static String generateBasicAuthHeader(String user, String password) {
        String credentials = user + ":" + password;
        String credentialsEncoded = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
        return "Basic " + credentialsEncoded;
    }
}

