/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.sw360.http.utils.HttpUtils;

public final class MultiStatusResponse {
    private static final String PROP_STATUS = "status";
    private static final String PROP_RES_ID = "resourceId";
    private static final TypeReference<List<Map<String, Object>>> REF_MULTI_RESPONSE = new TypeReference<List<Map<String, Object>>>(){};
    private final Map<String, Integer> responses;

    public MultiStatusResponse(Map<String, Integer> responses) {
        this.responses = Collections.unmodifiableMap(new HashMap<String, Integer>(responses));
    }

    public static MultiStatusResponse fromJson(ObjectMapper mapper, InputStream stream) throws IOException {
        List responses = (List)mapper.readValue(stream, REF_MULTI_RESPONSE);
        try {
            Map<String, Integer> responseMap = responses.stream().map(map -> new AbstractMap.SimpleEntry<String, Integer>(MultiStatusResponse.extractResourceId(map), MultiStatusResponse.extractStatus(map))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return new MultiStatusResponse(responseMap);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Failed to parse JSON response", e);
        }
    }

    public Map<String, Integer> getResponses() {
        return this.responses;
    }

    public int responseCount() {
        return this.responses.size();
    }

    public boolean isAllSuccess() {
        return this.responses.values().stream().allMatch(HttpUtils::isSuccessStatus);
    }

    public boolean hasResourceId(String resId) {
        return this.responses.containsKey(resId);
    }

    public int getStatus(String resId) {
        Integer status = this.responses.get(resId);
        if (status == null) {
            throw new NoSuchElementException("Unknown resource ID: " + resId + "; not contained in this multi-status response.");
        }
        return status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiStatusResponse response = (MultiStatusResponse)o;
        return this.responses.equals(response.responses);
    }

    public int hashCode() {
        return Objects.hash(this.responses);
    }

    public String toString() {
        return "MultiStatusResponse{responses=" + String.valueOf(this.responses) + "}";
    }

    private static String extractResourceId(Map<String, Object> map) {
        Object resourceId = map.get(PROP_RES_ID);
        if (!(resourceId instanceof String)) {
            throw new IllegalArgumentException("Unexpected JSON response. Expected resource ID, but found " + String.valueOf(resourceId));
        }
        return (String)resourceId;
    }

    private static Integer extractStatus(Map<String, Object> map) {
        Object status = map.get(PROP_STATUS);
        if (!(status instanceof Integer)) {
            throw new IllegalArgumentException("Unexpected JSON response. Expected status code, but found " + String.valueOf(status));
        }
        return (Integer)status;
    }
}

