/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.rest;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.eclipse.sw360.clients.auth.AccessTokenProvider;
import org.eclipse.sw360.clients.config.SW360ClientConfig;
import org.eclipse.sw360.clients.rest.SW360Client;
import org.eclipse.sw360.clients.rest.resource.LinkObjects;
import org.eclipse.sw360.clients.rest.resource.SW360HalResource;
import org.eclipse.sw360.clients.rest.resource.attachments.SW360Attachment;
import org.eclipse.sw360.clients.rest.resource.attachments.SW360AttachmentType;
import org.eclipse.sw360.http.RequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SW360AttachmentAwareClient<T extends SW360HalResource<?, ?>>
extends SW360Client {
    static final String TAG_UPLOAD_ATTACHMENT = "post_upload_attachment";
    static final String TAG_DOWNLOAD_ATTACHMENT = "get_download_attachment";
    static final String TAG_DELETE_ATTACHMENT = "delete_attachments";
    private static final Logger LOGGER = LoggerFactory.getLogger(SW360AttachmentAwareClient.class);
    private static final String ATTACHMENTS_ENDPOINT = "/attachments";

    protected SW360AttachmentAwareClient(SW360ClientConfig config, AccessTokenProvider provider) {
        super(config, provider);
    }

    protected abstract Class<T> getHandledClassType();

    public CompletableFuture<T> uploadAndAttachAttachment(T itemToModify, Path fileToAttach, SW360AttachmentType kindToAttach) {
        if (!Files.exists(fileToAttach, new LinkOption[0])) {
            LOGGER.warn("The file=[{}], which should be attached to release, does not exist", (Object)fileToAttach);
            CompletableFuture failedFuture = new CompletableFuture();
            failedFuture.completeExceptionally(new IOException("File to upload does not exist: " + String.valueOf(fileToAttach)));
            return failedFuture;
        }
        SW360Attachment sw360Attachment = new SW360Attachment(fileToAttach, kindToAttach);
        String self = ((LinkObjects)((SW360HalResource)itemToModify).getLinks()).getSelf().getHref();
        return this.executeJsonRequest(builder -> builder.method(RequestBuilder.Method.POST).uri(this.resolveAgainstBase(self + ATTACHMENTS_ENDPOINT).toString()).multiPart("attachment", part -> part.json((Object)sw360Attachment)).multiPart("file", part -> part.file(fileToAttach, "application/octet-stream")), this.getHandledClassType(), TAG_UPLOAD_ATTACHMENT);
    }

    public <S> CompletableFuture<S> processAttachment(String itemHref, String attachmentId, AttachmentProcessor<? extends S> processor) {
        String url = itemHref + "/attachments/" + attachmentId;
        return this.executeRequest(builder -> builder.uri(this.resolveAgainstBase(url).toString()).header("Accept", "application/*"), response -> processor.processAttachmentStream(response.bodyStream()), TAG_DOWNLOAD_ATTACHMENT);
    }

    public CompletableFuture<T> deleteAttachments(T entity, Collection<String> attachmentIds) {
        String url = ((SW360HalResource)entity).getSelfLink().getHref() + "/attachments/" + String.join((CharSequence)",", attachmentIds);
        return this.executeJsonRequest(builder -> builder.uri(this.resolveAgainstBase(url).toString()).method(RequestBuilder.Method.DELETE), this.getHandledClassType(), TAG_DELETE_ATTACHMENT);
    }

    @FunctionalInterface
    public static interface AttachmentProcessor<R> {
        public R processAttachmentStream(InputStream var1) throws IOException;
    }
}

