/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.rest;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.eclipse.sw360.clients.auth.AccessTokenProvider;
import org.eclipse.sw360.clients.config.SW360ClientConfig;
import org.eclipse.sw360.clients.rest.SW360Client;
import org.eclipse.sw360.clients.rest.resource.licenses.SW360License;
import org.eclipse.sw360.clients.rest.resource.licenses.SW360LicenseList;
import org.eclipse.sw360.clients.rest.resource.licenses.SW360SparseLicense;
import org.eclipse.sw360.clients.utils.SW360ResourceUtils;
import org.eclipse.sw360.http.RequestBuilder;
import org.eclipse.sw360.http.utils.HttpUtils;

public class SW360LicenseClient
extends SW360Client {
    static final String TAG_GET_LICENSES = "get_licenses";
    static final String TAG_GET_LICENSE_BY_NAME = "get_license_by_name";
    static final String TAG_CREATE_LICENSE = "post_create_license";
    static final String TAG_DELETE_LICENSE = "delete_license";
    private static final String LICENSES_ENDPOINT = "licenses";

    public SW360LicenseClient(SW360ClientConfig config, AccessTokenProvider provider) {
        super(config, provider);
    }

    public CompletableFuture<List<SW360SparseLicense>> getLicenses() {
        return this.executeJsonRequestWithDefault(HttpUtils.get((String)this.resourceUrl(LICENSES_ENDPOINT)), SW360LicenseList.class, TAG_GET_LICENSES, SW360LicenseList::new).thenApply(SW360ResourceUtils::getSw360SparseLicenses);
    }

    public CompletableFuture<SW360License> getLicenseByName(String name) {
        return this.executeJsonRequest(HttpUtils.get((String)this.resourceUrl(LICENSES_ENDPOINT, name)), SW360License.class, TAG_GET_LICENSE_BY_NAME);
    }

    public CompletableFuture<SW360License> createLicense(SW360License license) {
        return this.executeJsonRequest(builder -> builder.uri(this.resourceUrl(LICENSES_ENDPOINT)).method(RequestBuilder.Method.POST).body(bodyBuilder -> bodyBuilder.json((Object)license)), SW360License.class, TAG_CREATE_LICENSE);
    }

    public CompletableFuture<Integer> deleteLicense(String licenseId) {
        String url = this.resourceUrl(LICENSES_ENDPOINT, licenseId);
        return this.executeRequest(builder -> builder.uri(url).method(RequestBuilder.Method.DELETE), HttpUtils.checkResponse(response -> response.statusCode(), (Predicate)HttpUtils.hasStatus((int)200), (String)TAG_DELETE_LICENSE), TAG_DELETE_LICENSE);
    }
}

