/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.rest;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.sw360.clients.auth.AccessTokenProvider;
import org.eclipse.sw360.clients.config.SW360ClientConfig;
import org.eclipse.sw360.clients.rest.MultiStatusResponse;
import org.eclipse.sw360.clients.rest.SW360AttachmentAwareClient;
import org.eclipse.sw360.clients.rest.resource.releases.SW360Release;
import org.eclipse.sw360.clients.rest.resource.releases.SW360ReleaseList;
import org.eclipse.sw360.clients.rest.resource.releases.SW360SparseRelease;
import org.eclipse.sw360.clients.utils.SW360ResourceUtils;
import org.eclipse.sw360.http.RequestBuilder;
import org.eclipse.sw360.http.utils.HttpUtils;

public class SW360ReleaseClient
extends SW360AttachmentAwareClient<SW360Release> {
    static final String TAG_GET_RELEASE = "get_release";
    static final String TAG_GET_RELEASES_BY_EXTERNAL_IDS = "get_releases_by_external_ids";
    static final String TAG_CREATE_RELEASE = "post_create_release";
    static final String TAG_UPDATE_RELEASE = "patch_update_release";
    static final String TAG_DELETE_RELEASES = "delete_releases";
    private static final String RELEASES_ENDPOINT_APPENDIX = "releases";
    private static final String PATH_SEARCH_EXT_IDS = "searchByExternalIds";

    public SW360ReleaseClient(SW360ClientConfig config, AccessTokenProvider provider) {
        super(config, provider);
    }

    @Override
    public Class<SW360Release> getHandledClassType() {
        return SW360Release.class;
    }

    public CompletableFuture<SW360Release> getRelease(String releaseId) {
        return this.executeJsonRequest(HttpUtils.get((String)this.resourceUrl(RELEASES_ENDPOINT_APPENDIX, releaseId)), SW360Release.class, TAG_GET_RELEASE);
    }

    public CompletableFuture<List<SW360SparseRelease>> getReleasesByExternalIds(Map<String, ?> externalIds) {
        String url = this.getExternalIdUrl(externalIds);
        return this.executeJsonRequestWithDefault(HttpUtils.get((String)url), SW360ReleaseList.class, TAG_GET_RELEASES_BY_EXTERNAL_IDS, SW360ReleaseList::new).thenApply(SW360ResourceUtils::getSw360SparseReleases);
    }

    private String getExternalIdUrl(Map<String, ?> externalIds) {
        return HttpUtils.addQueryParameters((String)this.resourceUrl(RELEASES_ENDPOINT_APPENDIX, PATH_SEARCH_EXT_IDS), externalIds);
    }

    public CompletableFuture<SW360Release> createRelease(SW360Release sw360Release) {
        return this.executeJsonRequest(builder -> builder.method(RequestBuilder.Method.POST).uri(this.resourceUrl(RELEASES_ENDPOINT_APPENDIX)).body(body -> body.json((Object)sw360Release)), SW360Release.class, TAG_CREATE_RELEASE);
    }

    public CompletableFuture<SW360Release> patchRelease(SW360Release sw360Release) {
        return this.executeJsonRequest(builder -> builder.method(RequestBuilder.Method.PATCH).uri(this.resourceUrl(RELEASES_ENDPOINT_APPENDIX, sw360Release.getId())).body(body -> body.json((Object)sw360Release)), SW360Release.class, TAG_UPDATE_RELEASE);
    }

    public CompletableFuture<MultiStatusResponse> deleteReleases(Collection<String> idsToDelete) {
        return this.executeDeleteRequest(RELEASES_ENDPOINT_APPENDIX, idsToDelete, TAG_DELETE_RELEASES);
    }
}

