/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.clients.rest.resource.releases;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.sw360.clients.rest.resource.SW360HalResource;
import org.eclipse.sw360.clients.rest.resource.SW360HalResourceUtility;
import org.eclipse.sw360.clients.rest.resource.Self;
import org.eclipse.sw360.clients.rest.resource.attachments.SW360SparseAttachment;
import org.eclipse.sw360.clients.rest.resource.licenses.SW360SparseLicense;
import org.eclipse.sw360.clients.rest.resource.releases.SW360ClearingState;
import org.eclipse.sw360.clients.rest.resource.releases.SW360ReleaseEmbedded;
import org.eclipse.sw360.clients.rest.resource.releases.SW360ReleaseLinkObjects;

public final class SW360Release
extends SW360HalResource<SW360ReleaseLinkObjects, SW360ReleaseEmbedded> {
    private static final String OVERRIDDEN_LICENSES_KEY = "overridden_license";
    private static final String DECLARED_LICENSE_KEY = "declared_license";
    private static final String OBSERVED_LICENSES_KEY = "observed_license";
    private static final String RELEASE_TAG_URL_KEY = "release_tag";
    private static final String SOFTWARE_HERITAGE_ID_KEY = "swh";
    private static final String HASHES_PREFIX = "hash_";
    private static final String CHANGESTATUS_KEY = "change_status";
    private static final String COPYRIGHTS_KEY = "copyrights";
    private static final String CLEARINGSTATE_KEY = "clearingState";
    private static final String HOMEPAGE_KEY = "homepage";
    @JsonIgnore
    private boolean isProprietary;
    private String name;
    private String version;
    private String createdOn;
    private String cpeId;
    private String downloadurl;
    private SW360ClearingState sw360ClearingState;
    private final Map<String, String> externalIds = new HashMap<String, String>();
    @JsonSerialize
    private final Map<String, String> additionalData = new HashMap<String, String>();

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getComponentId() {
        return Optional.ofNullable((SW360ReleaseLinkObjects)this.getLinks()).map(SW360ReleaseLinkObjects::getSelfComponent).flatMap(SW360HalResourceUtility::getLastIndexOfSelfLink).orElse(null);
    }

    public SW360Release setComponentId(String componentId) {
        ((SW360ReleaseLinkObjects)this.getLinks()).setSelfComponent(new Self(componentId));
        return this;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    public SW360Release setName(String name) {
        this.name = name;
        return this;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVersion() {
        return this.version;
    }

    public SW360Release setVersion(String version) {
        this.version = version;
        return this;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedOn() {
        return this.createdOn;
    }

    public SW360Release setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCpeId() {
        return this.cpeId;
    }

    public SW360Release setCpeId(String cpeId) {
        this.cpeId = cpeId;
        return this;
    }

    @JsonIgnore
    public boolean isSetMainLicenseIds() {
        return !((SW360ReleaseEmbedded)this.getEmbedded()).getLicenses().isEmpty();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Set<String> getMainLicenseIds() {
        return Optional.ofNullable(((SW360ReleaseEmbedded)this.getEmbedded()).getLicenses()).map(lics -> lics.stream().filter(Objects::nonNull).map(SW360SparseLicense::getShortName).collect(Collectors.toSet())).orElse(Collections.emptySet());
    }

    public SW360Release setMainLicenseIds(Set<String> mainLicenseIds) {
        if (!mainLicenseIds.isEmpty()) {
            List<SW360SparseLicense> licenses = mainLicenseIds.stream().map(licenseId -> new SW360SparseLicense().setShortName((String)licenseId)).collect(Collectors.toList());
            ((SW360ReleaseEmbedded)this.getEmbedded()).setLicenses(licenses);
        }
        return this;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDownloadurl() {
        return this.downloadurl;
    }

    public void setDownloadurl(String downloadurl) {
        this.downloadurl = downloadurl;
    }

    @JsonIgnore
    public Map<String, String> getCoordinates() {
        return this.externalIds.entrySet().stream().filter(e -> ((String)e.getValue()).startsWith("pkg:")).filter(e -> SW360Release.isValidPkgUrl((String)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public SW360Release setCoordinates(Map<String, String> coordinates) {
        coordinates.entrySet().stream().filter(entry -> SW360Release.isValidPkgUrl((String)entry.getValue())).forEach(entry -> this.externalIds.put((String)entry.getKey(), (String)entry.getValue()));
        return this;
    }

    private static boolean isValidPkgUrl(String purl) {
        try {
            new PackageURL(purl);
            return true;
        }
        catch (MalformedPackageURLException e) {
            return false;
        }
    }

    @JsonIgnore
    public String getOverriddenLicense() {
        return this.additionalData.get(OVERRIDDEN_LICENSES_KEY);
    }

    public SW360Release setOverriddenLicense(String overriddenLicense) {
        this.additionalData.put(OVERRIDDEN_LICENSES_KEY, overriddenLicense);
        return this;
    }

    @JsonIgnore
    public String getDeclaredLicense() {
        return this.additionalData.get(DECLARED_LICENSE_KEY);
    }

    public SW360Release setDeclaredLicense(String declaredLicense) {
        this.additionalData.put(DECLARED_LICENSE_KEY, declaredLicense);
        return this;
    }

    @JsonIgnore
    public String getObservedLicense() {
        return this.additionalData.get(OBSERVED_LICENSES_KEY);
    }

    public SW360Release setObservedLicense(String observedLicense) {
        this.additionalData.put(OBSERVED_LICENSES_KEY, observedLicense);
        return this;
    }

    @JsonIgnore
    public String getReleaseTagUrl() {
        return this.externalIds.get(RELEASE_TAG_URL_KEY);
    }

    public SW360Release setReleaseTagUrl(String releaseTagUrl) {
        this.externalIds.put(RELEASE_TAG_URL_KEY, releaseTagUrl);
        return this;
    }

    @JsonIgnore
    public String getSoftwareHeritageId() {
        return this.externalIds.get(SOFTWARE_HERITAGE_ID_KEY);
    }

    public SW360Release setSoftwareHeritageId(String softwareHeritageId) {
        this.externalIds.put(SOFTWARE_HERITAGE_ID_KEY, softwareHeritageId);
        return this;
    }

    @JsonIgnore
    public Set<String> getHashes() {
        return this.externalIds.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(HASHES_PREFIX)).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    private void dropAllHashes() {
        this.externalIds.keySet().stream().filter(s -> s.startsWith(HASHES_PREFIX)).forEach(this.externalIds::remove);
    }

    public SW360Release setHashes(Set<String> hashes) {
        this.dropAllHashes();
        int i = 1;
        for (String hash : hashes) {
            if (hash == null || hash.isEmpty()) continue;
            this.externalIds.put(HASHES_PREFIX + i, hash);
            ++i;
        }
        return this;
    }

    @JsonIgnore
    public String getClearingState() {
        return this.additionalData.get(CLEARINGSTATE_KEY);
    }

    public SW360Release setClearingState(String clearingState) {
        this.additionalData.put(CLEARINGSTATE_KEY, clearingState);
        return this;
    }

    @JsonProperty(value="clearingState")
    public SW360ClearingState getSw360ClearingState() {
        return this.sw360ClearingState;
    }

    public void setSw360ClearingState(SW360ClearingState sw360ClearingState) {
        this.sw360ClearingState = sw360ClearingState;
    }

    @JsonIgnore
    public String getChangeStatus() {
        return this.additionalData.get(CHANGESTATUS_KEY);
    }

    public SW360Release setChangeStatus(String changeStatus) {
        this.additionalData.put(CHANGESTATUS_KEY, changeStatus);
        return this;
    }

    @JsonIgnore
    public String getCopyrights() {
        return this.additionalData.get(COPYRIGHTS_KEY);
    }

    public SW360Release setCopyrights(String copyrights) {
        this.additionalData.put(COPYRIGHTS_KEY, copyrights);
        return this;
    }

    @JsonIgnore
    public boolean isProprietary() {
        return this.isProprietary;
    }

    @JsonIgnore
    public SW360Release setProprietary(boolean proprietary) {
        this.isProprietary = proprietary;
        return this;
    }

    @JsonIgnore
    public String getHomepageUrl() {
        return this.additionalData.get(HOMEPAGE_KEY);
    }

    public SW360Release setHomepageUrl(String homepageUrl) {
        this.additionalData.put(HOMEPAGE_KEY, homepageUrl);
        return this;
    }

    public Map<String, String> getExternalIds() {
        return new HashMap<String, String>(this.externalIds);
    }

    public SW360Release setExternalIds(Map<String, String> externalIds) {
        this.externalIds.putAll(externalIds);
        return this;
    }

    public SW360Release setAdditionalData(Map<String, String> additionalData) {
        this.additionalData.putAll(additionalData);
        return this;
    }

    public boolean shareIdentifier(SW360Release releaseCompare) {
        return this.name.equals(Optional.of(releaseCompare.getName()).orElse("")) && this.version.equals(Optional.of(releaseCompare.getVersion()).orElse(""));
    }

    public SW360Release mergeWith(SW360Release releaseWithPrecedence) {
        Set<SW360SparseAttachment> releaseWithPrecedenceAttachments;
        Self componentIdWithPrecedence;
        Self releaseIdWithPrecedence;
        this.name = this.getDominantGetterFromVariableMergeOrNull(releaseWithPrecedence, SW360Release::getName);
        this.version = this.getDominantGetterFromVariableMergeOrNull(releaseWithPrecedence, SW360Release::getVersion);
        this.cpeId = this.getDominantGetterFromVariableMergeOrNull(releaseWithPrecedence, SW360Release::getCpeId);
        this.downloadurl = this.getDominantGetterFromVariableMergeOrNull(releaseWithPrecedence, SW360Release::getDownloadurl);
        if (releaseWithPrecedence.isSetMainLicenseIds()) {
            this.setMainLicenseIds(releaseWithPrecedence.getMainLicenseIds());
        }
        if ((releaseIdWithPrecedence = ((SW360ReleaseLinkObjects)releaseWithPrecedence.getLinks()).getSelf()) != null && !releaseIdWithPrecedence.getHref().isEmpty()) {
            ((SW360ReleaseLinkObjects)this.getLinks()).setSelf(releaseIdWithPrecedence);
        }
        if ((componentIdWithPrecedence = ((SW360ReleaseLinkObjects)releaseWithPrecedence.getLinks()).getSelfComponent()) != null && !componentIdWithPrecedence.getHref().isEmpty()) {
            ((SW360ReleaseLinkObjects)this.getLinks()).setSelfComponent(componentIdWithPrecedence);
        }
        if (!(releaseWithPrecedenceAttachments = ((SW360ReleaseEmbedded)releaseWithPrecedence.getEmbedded()).getAttachments()).isEmpty()) {
            if (((SW360ReleaseEmbedded)this.getEmbedded()).getAttachments().isEmpty()) {
                ((SW360ReleaseEmbedded)this.getEmbedded()).setAttachments(releaseWithPrecedenceAttachments);
            } else {
                ((SW360ReleaseEmbedded)this.getEmbedded()).setAttachments(this.mergeAttachments(((SW360ReleaseEmbedded)this.getEmbedded()).getAttachments(), releaseWithPrecedenceAttachments));
            }
        }
        this.externalIds.putAll(releaseWithPrecedence.externalIds);
        this.additionalData.putAll(releaseWithPrecedence.additionalData);
        return this;
    }

    private Set<SW360SparseAttachment> mergeAttachments(Set<SW360SparseAttachment> attachments, Set<SW360SparseAttachment> releaseWithPrecedenceAttachments) {
        attachments.addAll(releaseWithPrecedenceAttachments);
        return attachments;
    }

    private <T> T getDominantGetterFromVariableMergeOrNull(SW360Release release, Function<SW360Release, T> getter) {
        return Optional.ofNullable(getter.apply(release)).orElse(getter.apply(this));
    }

    @Override
    public SW360ReleaseLinkObjects createEmptyLinks() {
        return new SW360ReleaseLinkObjects();
    }

    @Override
    public SW360ReleaseEmbedded createEmptyEmbedded() {
        return new SW360ReleaseEmbedded();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SW360Release) || !super.equals(o)) {
            return false;
        }
        SW360Release release = (SW360Release)o;
        return Objects.equals(this.name, release.name) && Objects.equals(this.version, release.version) && Objects.equals(this.cpeId, release.cpeId) && Objects.equals(this.downloadurl, release.downloadurl) && Objects.equals(this.externalIds, release.externalIds) && Objects.equals(this.additionalData, release.additionalData) && Objects.equals(this.createdOn, release.createdOn) && Objects.equals((Object)this.sw360ClearingState, (Object)release.sw360ClearingState) && this.isProprietary == release.isProprietary;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.name, this.version, this.cpeId, this.downloadurl, this.externalIds, this.additionalData, this.isProprietary, this.createdOn, this.sw360ClearingState});
    }

    @Override
    public boolean canEqual(Object o) {
        return o instanceof SW360Release;
    }
}

