/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Consumer;
import okhttp3.Headers;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.eclipse.sw360.http.RequestBodyBuilder;
import org.eclipse.sw360.http.RequestBodyBuilderImpl;
import org.eclipse.sw360.http.RequestBuilder;

class RequestBuilderImpl
implements RequestBuilder {
    private final ObjectMapper mapper;
    private final Request.Builder requestBuilder;
    private final Headers.Builder headersBuilder;
    private String httpMethod;
    private RequestBody body;
    private MultipartBody.Builder multipartBuilder;

    public RequestBuilderImpl(ObjectMapper mapper) {
        this.mapper = mapper;
        this.requestBuilder = new Request.Builder();
        this.headersBuilder = new Headers.Builder();
        this.httpMethod = RequestBuilder.Method.GET.name();
    }

    @Override
    public RequestBuilder method(RequestBuilder.Method method) {
        this.httpMethod = method.name();
        return this;
    }

    @Override
    public RequestBuilder uri(String uri) {
        this.requestBuilder.url(uri);
        return this;
    }

    @Override
    public RequestBuilder header(String name, String value) {
        this.headersBuilder.add(name, value);
        return this;
    }

    @Override
    public RequestBuilder body(Consumer<RequestBodyBuilder> bodyProducer) {
        if (this.multipartBuilder != null) {
            throw new IllegalStateException("A normal body cannot be added to a multipart request");
        }
        if (this.getBody() != null) {
            throw new IllegalStateException("A request can only have a single body");
        }
        RequestBodyBuilderImpl bodyBuilder = new RequestBodyBuilderImpl(this.mapper);
        bodyProducer.accept(bodyBuilder);
        this.body = bodyBuilder.getBody();
        return this;
    }

    @Override
    public RequestBuilder multiPart(String name, Consumer<RequestBodyBuilder> partProducer) {
        if (this.getBody() != null) {
            throw new IllegalStateException("The request already has a normal body. You can either have a body or a multipart request, but not both.");
        }
        if (this.multipartBuilder == null) {
            this.multipartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        }
        RequestBodyBuilderImpl bodyBuilder = new RequestBodyBuilderImpl(this.mapper);
        partProducer.accept(bodyBuilder);
        this.multipartBuilder.addFormDataPart(name, bodyBuilder.getFileName(), bodyBuilder.getBody());
        return this;
    }

    public Request build() {
        RequestBody requestBody = this.multipartBuilder != null ? this.multipartBuilder.build() : this.getBody();
        return this.requestBuilder.method(this.httpMethod, requestBody).headers(this.getHeaders()).build();
    }

    Headers getHeaders() {
        return this.headersBuilder.build();
    }

    RequestBody getBody() {
        return this.body;
    }
}

