/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import okhttp3.ResponseBody;
import org.eclipse.sw360.http.Response;

class ResponseImpl
implements Response {
    private static final InputStream EMPTY_STREAM = new ByteArrayInputStream(new byte[0]);
    private final okhttp3.Response response;

    public ResponseImpl(okhttp3.Response response) {
        this.response = response;
    }

    @Override
    public int statusCode() {
        return this.response.code();
    }

    @Override
    public boolean isSuccess() {
        return this.response.isSuccessful();
    }

    @Override
    public Set<String> headerNames() {
        return this.response.headers().names();
    }

    @Override
    public String header(String name) {
        return this.response.header(name);
    }

    @Override
    public InputStream bodyStream() {
        ResponseBody body = this.response.body();
        return body != null ? body.byteStream() : EMPTY_STREAM;
    }
}

