/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.http.config;

import java.util.Objects;

public final class ProxySettings {
    private static final String UNDEFINED_HOST = "";
    private static final int UNDEFINED_PORT = -1;
    private static final ProxySettings DEFAULT_SELECTOR_SETTINGS = new ProxySettings("", 0);
    private static final ProxySettings NO_PROXY_SETTINGS = new ProxySettings(null, -1);
    private final String proxyHost;
    private final int proxyPort;

    private ProxySettings(String proxyHost, int proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public static ProxySettings noProxy() {
        return NO_PROXY_SETTINGS;
    }

    public static ProxySettings defaultProxySelector() {
        return DEFAULT_SELECTOR_SETTINGS;
    }

    public static ProxySettings useProxy(String host, int port) {
        return new ProxySettings(host, port);
    }

    public static ProxySettings fromConfig(boolean useProxy, String host, int port) {
        if (!useProxy) {
            return ProxySettings.noProxy();
        }
        return host != null && !UNDEFINED_HOST.equals(host) && port > 0 ? ProxySettings.useProxy(host, port) : ProxySettings.defaultProxySelector();
    }

    public boolean isProxyUse() {
        return this.getProxyHost() != null && this.getProxyPort() != -1;
    }

    public boolean isDefaultProxySelectorUse() {
        return UNDEFINED_HOST.equals(this.getProxyHost());
    }

    public boolean isNoProxy() {
        return !this.isProxyUse() && !this.isDefaultProxySelectorUse();
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxySettings settings = (ProxySettings)o;
        return this.getProxyPort() == settings.getProxyPort() && Objects.equals(this.getProxyHost(), settings.getProxyHost());
    }

    public int hashCode() {
        return Objects.hash(this.getProxyHost(), this.getProxyPort());
    }

    public String toString() {
        return "ProxySettings{, proxyHost='" + this.proxyHost + "', proxyPort=" + this.proxyPort + "}";
    }
}

