/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.http.utils;

import java.io.IOException;

public class FailedRequestException
extends IOException {
    private final String tag;
    private final int statusCode;

    public FailedRequestException(String tag, int statusCode) {
        this(tag, statusCode, null);
    }

    public FailedRequestException(String tag, int statusCode, String serverMessage) {
        super(FailedRequestException.generateMessage(tag, statusCode, serverMessage));
        this.tag = tag;
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getTag() {
        return this.tag;
    }

    private static String generateMessage(String tag, int statusCode, String serverMessage) {
        StringBuilder buf = new StringBuilder();
        if (tag != null) {
            buf.append("The request '").append(tag).append('\'');
        } else {
            buf.append("A request");
        }
        buf.append(" failed with status code ").append(statusCode).append('.');
        if (serverMessage != null && !serverMessage.isEmpty()) {
            buf.append(" Message from the server:").append(System.lineSeparator()).append('\"').append(serverMessage).append('\"');
        }
        return buf.toString();
    }
}

