/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.message.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.tahu.message.model.Metric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SparkplugBPayload {
    private static Logger logger = LoggerFactory.getLogger((String)SparkplugBPayload.class.getName());
    private Date timestamp;
    private List<Metric> metrics;
    private Long seq = null;
    private String uuid;
    private byte[] body;

    public SparkplugBPayload() {
    }

    public SparkplugBPayload(Date timestamp, List<Metric> metrics, Long seq, String uuid, byte[] body) {
        this(timestamp, metrics, seq);
        this.uuid = uuid;
        this.body = body;
    }

    public SparkplugBPayload(Date timestamp, List<Metric> metrics, Long seq) {
        this(timestamp, metrics);
        this.seq = seq;
    }

    public SparkplugBPayload(Date timestamp, List<Metric> metrics) {
        this.timestamp = timestamp;
        this.metrics = metrics;
    }

    public SparkplugBPayload(SparkplugBPayload payload) {
        this.timestamp = payload.getTimestamp();
        if (payload.getMetrics() != null) {
            this.metrics = new ArrayList<Metric>();
            for (Metric metric : payload.getMetrics()) {
                try {
                    this.metrics.add(new Metric(metric));
                }
                catch (Exception e) {
                    logger.error("Failed to copy metric: {}", (Object)metric, (Object)e);
                }
            }
        }
        this.seq = payload.getSeq();
        this.uuid = payload.getUuid();
        this.body = payload.getBody();
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void addMetric(Metric metric) {
        this.metrics.add(metric);
    }

    public void addMetric(int index, Metric metric) {
        this.metrics.add(index, metric);
    }

    public void addMetrics(List<Metric> metrics) {
        this.metrics.addAll(metrics);
    }

    public Metric removeMetric(int index) {
        return this.metrics.remove(index);
    }

    public boolean removeMetric(Metric metric) {
        return this.metrics.remove(metric);
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    @JsonIgnore
    public Integer getMetricCount() {
        return this.metrics.size();
    }

    public void setMetrics(List<Metric> metrics) {
        this.metrics = metrics;
    }

    public Long getSeq() {
        return this.seq;
    }

    public void setSeq(Long seq) {
        this.seq = seq;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SparkplugBPayload [timestamp=");
        builder.append(this.timestamp != null ? Long.valueOf(this.timestamp.getTime()) : "null");
        builder.append(", metrics=");
        builder.append(this.metrics);
        builder.append(", seq=");
        builder.append(this.seq != null ? this.seq : "null");
        builder.append(", uuid=");
        builder.append(this.uuid);
        builder.append(", body=");
        builder.append(Arrays.toString(this.body));
        builder.append("]");
        return builder.toString();
    }

    public static class SparkplugBPayloadBuilder {
        private Date timestamp;
        private List<Metric> metrics;
        private Long seq = null;
        private String uuid;
        private byte[] body;

        public SparkplugBPayloadBuilder(Long sequenceNumber) {
            this.seq = sequenceNumber;
            this.metrics = new ArrayList<Metric>();
        }

        public SparkplugBPayloadBuilder() {
            this.metrics = new ArrayList<Metric>();
        }

        public SparkplugBPayloadBuilder addMetric(Metric metric) {
            this.metrics.add(metric);
            return this;
        }

        public SparkplugBPayloadBuilder addMetrics(Collection<Metric> metrics) {
            this.metrics.addAll(metrics);
            return this;
        }

        public SparkplugBPayloadBuilder setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SparkplugBPayloadBuilder setSeq(Long seq) {
            this.seq = seq;
            return this;
        }

        public SparkplugBPayloadBuilder setUuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public SparkplugBPayloadBuilder setBody(byte[] body) {
            this.body = body;
            return this;
        }

        public SparkplugBPayload createPayload() {
            return new SparkplugBPayload(this.timestamp, this.metrics, this.seq, this.uuid, this.body);
        }
    }
}

