/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.host.manager;

import java.util.Date;
import org.eclipse.tahu.host.manager.MetricManager;
import org.eclipse.tahu.host.manager.SparkplugEdgeNode;
import org.eclipse.tahu.message.model.DeviceDescriptor;
import org.eclipse.tahu.message.model.SparkplugDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkplugDevice
extends MetricManager {
    private static Logger logger = LoggerFactory.getLogger((String)SparkplugDevice.class.getName());
    private final SparkplugEdgeNode sparkplugEdgeNode;
    private final DeviceDescriptor deviceDescriptor;
    private final String groupId;
    private final String edgeNodeId;
    private final String deviceId;
    private boolean online;
    private Date onlineTimestamp;
    private Date offlineTimestamp;

    SparkplugDevice(SparkplugEdgeNode sparkplugEdgeNode, String groupId, String edgeNodeId, String deviceId, Date onlineTimestamp) {
        this(sparkplugEdgeNode, new DeviceDescriptor(groupId, edgeNodeId, deviceId), onlineTimestamp);
    }

    SparkplugDevice(SparkplugEdgeNode sparkplugEdgeNode, DeviceDescriptor deviceDescriptor, Date onlineTimestamp) {
        this.sparkplugEdgeNode = sparkplugEdgeNode;
        this.deviceDescriptor = deviceDescriptor;
        this.groupId = deviceDescriptor.getGroupId();
        this.edgeNodeId = deviceDescriptor.getEdgeNodeId();
        this.deviceId = deviceDescriptor.getDeviceId();
        this.online = true;
        this.onlineTimestamp = onlineTimestamp;
    }

    @Override
    public SparkplugDescriptor getSparkplugDescriptor() {
        return this.deviceDescriptor;
    }

    public SparkplugEdgeNode getSparkplugEdgeNode() {
        return this.sparkplugEdgeNode;
    }

    public DeviceDescriptor getDeviceDescrptor() {
        return this.deviceDescriptor;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getEdgeNodeId() {
        return this.edgeNodeId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online, Date timestamp) {
        this.online = online;
        if (online) {
            logger.info("Device {} set online at {}", (Object)this.deviceDescriptor, (Object)timestamp);
            this.onlineTimestamp = timestamp;
        } else {
            logger.info("Device {} set offline at {}", (Object)this.deviceDescriptor, (Object)timestamp);
            this.offlineTimestamp = timestamp;
        }
    }

    public Date getOnlineTimestamp() {
        return this.onlineTimestamp;
    }

    public Date getOfflineTimestamp() {
        return this.offlineTimestamp;
    }
}

