/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tahu.host.manager;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.tahu.exception.TahuErrorCode;
import org.eclipse.tahu.exception.TahuException;
import org.eclipse.tahu.host.manager.MetricManager;
import org.eclipse.tahu.host.manager.SparkplugDevice;
import org.eclipse.tahu.message.model.DeviceDescriptor;
import org.eclipse.tahu.message.model.EdgeNodeDescriptor;
import org.eclipse.tahu.message.model.SparkplugDescriptor;
import org.eclipse.tahu.mqtt.MqttClientId;
import org.eclipse.tahu.mqtt.MqttServerName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkplugEdgeNode
extends MetricManager {
    private static Logger logger = LoggerFactory.getLogger((String)SparkplugEdgeNode.class.getName());
    private final EdgeNodeDescriptor edgeNodeDescriptor;
    private final String groupId;
    private final String edgeNodeId;
    private final Map<DeviceDescriptor, SparkplugDevice> sparkplugDevices;
    private MqttServerName mqttServerName;
    private MqttClientId hostAppMqttClientId;
    private boolean online;
    private Date onlineTimestamp;
    private Date offlineTimestamp;
    private Long birthBdSeqNum;
    private Long lastSeqNum;
    private final Object lock = new Object();

    SparkplugEdgeNode(String groupId, String edgeNodeId, MqttServerName mqttServerName, MqttClientId hostAppMqttClientId) {
        this(new EdgeNodeDescriptor(groupId, edgeNodeId), mqttServerName, hostAppMqttClientId);
    }

    SparkplugEdgeNode(EdgeNodeDescriptor edgeNodeDescriptor, MqttServerName mqttServerName, MqttClientId hostAppMqttClientId) {
        this.edgeNodeDescriptor = edgeNodeDescriptor;
        this.groupId = edgeNodeDescriptor.getGroupId();
        this.edgeNodeId = edgeNodeDescriptor.getEdgeNodeId();
        this.sparkplugDevices = new ConcurrentHashMap<DeviceDescriptor, SparkplugDevice>();
        this.mqttServerName = mqttServerName;
        this.hostAppMqttClientId = hostAppMqttClientId;
    }

    @Override
    public SparkplugDescriptor getSparkplugDescriptor() {
        return this.edgeNodeDescriptor;
    }

    public EdgeNodeDescriptor getEdgeNodeDescriptor() {
        return this.edgeNodeDescriptor;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getEdgeNodeId() {
        return this.edgeNodeId;
    }

    public void addDevice(DeviceDescriptor deviceDescriptor, SparkplugDevice sparkplugDevice) {
        this.sparkplugDevices.put(deviceDescriptor, sparkplugDevice);
    }

    public Map<DeviceDescriptor, SparkplugDevice> getSparkplugDevices() {
        return Collections.unmodifiableMap(this.sparkplugDevices);
    }

    public SparkplugDevice getSparkplugDevice(DeviceDescriptor deviceDescriptor) {
        return this.sparkplugDevices.get(deviceDescriptor);
    }

    public MqttServerName getMqttServerName() {
        return this.mqttServerName;
    }

    public void setMqttServerName(MqttServerName mqttServerName) {
        this.mqttServerName = mqttServerName;
    }

    public MqttClientId getHostAppMqttClientId() {
        return this.hostAppMqttClientId;
    }

    public void setHostAppMqttClientId(MqttClientId hostAppMqttClientId) {
        this.hostAppMqttClientId = hostAppMqttClientId;
    }

    public boolean isOnline() {
        return this.online;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnline(boolean online, Date timestamp, Long incomingBdSeq, Long incomingSeq) throws TahuException {
        Object object = this.lock;
        synchronized (object) {
            if (online) {
                if (timestamp == null) {
                    throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "The timestamp can not be missing from an NBIRTH message");
                }
                if (incomingBdSeq == null) {
                    throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "The bdSeq can not be missing from an NBIRTH message");
                }
                this.online = online;
                this.onlineTimestamp = timestamp;
                this.birthBdSeqNum = incomingBdSeq;
                this.lastSeqNum = incomingSeq;
            } else {
                if (incomingBdSeq == null) {
                    throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "The bdSeq can not be missing from an NDEATH message");
                }
                if (this.birthBdSeqNum != incomingBdSeq) {
                    logger.debug("Mismatched bdSeq number - got {} expected {} - ignoring", (Object)incomingBdSeq, (Object)this.birthBdSeqNum);
                    return;
                }
                this.online = online;
                this.offlineTimestamp = timestamp;
            }
            logger.info("Edge Node {} set {} at {}", new Object[]{this.edgeNodeDescriptor, online ? "online" : "offline", timestamp});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceOffline(Date timestamp) {
        Object object = this.lock;
        synchronized (object) {
            this.online = false;
            this.offlineTimestamp = timestamp;
        }
    }

    public Date getOnlineTimestamp() {
        return this.onlineTimestamp;
    }

    public Date getOfflineTimestamp() {
        return this.offlineTimestamp;
    }

    public Long getBirthBdSeqNum() {
        return this.birthBdSeqNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSeq(Long incomingSeq) throws TahuException {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastSeqNum != null) {
                Long l = this.lastSeqNum;
                Long l2 = this.lastSeqNum = Long.valueOf(this.lastSeqNum + 1L);
                if (this.lastSeqNum.equals(256L)) {
                    this.lastSeqNum = 0L;
                }
                if (!this.lastSeqNum.equals(incomingSeq)) {
                    throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "The sequence number check did not pass - expected " + this.lastSeqNum + " but received " + incomingSeq);
                }
            } else {
                throw new TahuException(TahuErrorCode.INVALID_ARGUMENT, "The sequence number check did not pass - expected " + this.lastSeqNum + " but received " + incomingSeq);
            }
        }
    }
}

