/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.edc.edr.spi.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.edc.spi.entity.StatefulEntity;
import org.eclipse.tractusx.edc.edr.spi.types.EndpointDataReferenceEntryStates;

@JsonDeserialize(builder=Builder.class)
public class EndpointDataReferenceEntry
extends StatefulEntity<EndpointDataReferenceEntry> {
    public static final String SIMPLE_TYPE = "EndpointDataReferenceEntry";
    public static final String EDR_ENTRY_TYPE = "https://w3id.org/tractusx/v0.0.1/ns/EndpointDataReferenceEntry";
    public static final String EDR_ENTRY_STATE = "https://w3id.org/tractusx/v0.0.1/ns/edrState";
    public static final String EDR_ENTRY_EXPIRATION_DATE = "https://w3id.org/tractusx/v0.0.1/ns/expirationDate";
    public static final String ASSET_ID = "assetId";
    public static final String EDR_ENTRY_ASSET_ID = "https://w3id.org/edc/v0.0.1/ns/assetId";
    public static final String AGREEMENT_ID = "agreementId";
    public static final String EDR_ENTRY_AGREEMENT_ID = "https://w3id.org/edc/v0.0.1/ns/agreementId";
    public static final String CONTRACT_NEGOTIATION_ID = "contractNegotiationId";
    public static final String EDR_ENTRY_CONTRACT_NEGOTIATION_ID = "https://w3id.org/edc/v0.0.1/ns/contractNegotiationId";
    public static final String TRANSFER_PROCESS_ID = "transferProcessId";
    public static final String EDR_ENTRY_TRANSFER_PROCESS_ID = "https://w3id.org/edc/v0.0.1/ns/transferProcessId";
    public static final String PROVIDER_ID = "providerId";
    public static final String EDR_ENTRY_PROVIDER_ID = "https://w3id.org/edc/v0.0.1/ns/providerId";
    private String assetId;
    private String agreementId;
    private String transferProcessId;
    private String contractNegotiationId;
    private String providerId;
    private Long expirationTimestamp;

    private EndpointDataReferenceEntry() {
        this.state = EndpointDataReferenceEntryStates.NEGOTIATED.code();
    }

    public String getId() {
        return this.getTransferProcessId();
    }

    public EndpointDataReferenceEntry copy() {
        Builder builder = Builder.newInstance().transferProcessId(this.transferProcessId).agreementId(this.agreementId).assetId(this.assetId).providerId(this.providerId).contractNegotiationId(this.contractNegotiationId).expirationTimestamp(this.expirationTimestamp);
        return (EndpointDataReferenceEntry)this.copy(builder);
    }

    public String stateAsString() {
        return EndpointDataReferenceEntryStates.from(this.state).toString();
    }

    @JsonIgnore
    public String getEdrState() {
        return EndpointDataReferenceEntryStates.from(this.getState()).name();
    }

    public String getAssetId() {
        return this.assetId;
    }

    public String getAgreementId() {
        return this.agreementId;
    }

    public String getTransferProcessId() {
        return this.transferProcessId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getContractNegotiationId() {
        return this.contractNegotiationId;
    }

    public Long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    public int hashCode() {
        return Objects.hash(this.assetId, this.agreementId, this.transferProcessId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EndpointDataReferenceEntry that = (EndpointDataReferenceEntry)((Object)o);
        return this.transferProcessId.equals(that.transferProcessId);
    }

    public void transitionToRefreshing() {
        this.transition(EndpointDataReferenceEntryStates.REFRESHING, EndpointDataReferenceEntryStates.REFRESHING, EndpointDataReferenceEntryStates.NEGOTIATED);
    }

    public void transitionToNegotiated() {
        this.transition(EndpointDataReferenceEntryStates.NEGOTIATED, EndpointDataReferenceEntryStates.NEGOTIATED, EndpointDataReferenceEntryStates.REFRESHING);
    }

    public void transitionError() {
        this.transition(EndpointDataReferenceEntryStates.ERROR, EndpointDataReferenceEntryStates.REFRESHING, EndpointDataReferenceEntryStates.NEGOTIATED);
    }

    public void transitionToExpired() {
        this.transition(EndpointDataReferenceEntryStates.EXPIRED, EndpointDataReferenceEntryStates.EXPIRED, EndpointDataReferenceEntryStates.NEGOTIATED, EndpointDataReferenceEntryStates.REFRESHING);
    }

    public void transitionToDeleting() {
        this.transition(EndpointDataReferenceEntryStates.DELETING, EndpointDataReferenceEntryStates.DELETING, EndpointDataReferenceEntryStates.EXPIRED);
    }

    private void transition(EndpointDataReferenceEntryStates end, Predicate<EndpointDataReferenceEntryStates> canTransitTo) {
        if (!canTransitTo.test(EndpointDataReferenceEntryStates.from(this.state))) {
            throw new IllegalStateException(String.format("Cannot transition from state %s to %s", new Object[]{EndpointDataReferenceEntryStates.from(this.state), EndpointDataReferenceEntryStates.from(end.code())}));
        }
        this.transitionTo(end.code());
    }

    private void transition(EndpointDataReferenceEntryStates end, EndpointDataReferenceEntryStates ... starts) {
        this.transition(end, (EndpointDataReferenceEntryStates state) -> Arrays.stream(starts).anyMatch(s -> s == state));
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends StatefulEntity.Builder<EndpointDataReferenceEntry, Builder> {
        private Builder() {
            super((StatefulEntity)new EndpointDataReferenceEntry());
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder assetId(String assetId) {
            ((EndpointDataReferenceEntry)this.entity).assetId = assetId;
            return this;
        }

        public Builder agreementId(String agreementId) {
            ((EndpointDataReferenceEntry)this.entity).agreementId = agreementId;
            return this;
        }

        public Builder transferProcessId(String transferProcessId) {
            ((EndpointDataReferenceEntry)this.entity).transferProcessId = transferProcessId;
            ((EndpointDataReferenceEntry)this.entity).id = transferProcessId;
            return this;
        }

        public Builder providerId(String providerId) {
            ((EndpointDataReferenceEntry)this.entity).providerId = providerId;
            return this;
        }

        public Builder contractNegotiationId(String contractNegotiationId) {
            ((EndpointDataReferenceEntry)this.entity).contractNegotiationId = contractNegotiationId;
            return this;
        }

        public Builder expirationTimestamp(Long expirationTimestamp) {
            ((EndpointDataReferenceEntry)this.entity).expirationTimestamp = expirationTimestamp;
            return this;
        }

        public Builder self() {
            return this;
        }

        public EndpointDataReferenceEntry build() {
            super.build();
            Objects.requireNonNull(((EndpointDataReferenceEntry)this.entity).assetId, EndpointDataReferenceEntry.ASSET_ID);
            Objects.requireNonNull(((EndpointDataReferenceEntry)this.entity).agreementId, EndpointDataReferenceEntry.AGREEMENT_ID);
            Objects.requireNonNull(((EndpointDataReferenceEntry)this.entity).transferProcessId, EndpointDataReferenceEntry.TRANSFER_PROCESS_ID);
            return (EndpointDataReferenceEntry)this.entity;
        }
    }
}

