/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.edc.edr.spi.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.edc.spi.types.domain.callback.CallbackAddress;
import org.eclipse.edc.spi.types.domain.offer.ContractOffer;

public class NegotiateEdrRequest {
    private String connectorAddress;
    private String protocol = "ids-multipart";
    private String connectorId;
    private ContractOffer offer;
    private List<CallbackAddress> callbackAddresses = new ArrayList<CallbackAddress>();

    private NegotiateEdrRequest() {
    }

    public String getConnectorAddress() {
        return this.connectorAddress;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public List<CallbackAddress> getCallbackAddresses() {
        return this.callbackAddresses;
    }

    public ContractOffer getOffer() {
        return this.offer;
    }

    public static final class Builder {
        private final NegotiateEdrRequest entity = new NegotiateEdrRequest();

        private Builder() {
        }

        public Builder connectorAddress(String connectorAddress) {
            this.entity.connectorAddress = connectorAddress;
            return this;
        }

        public Builder protocol(String protocol) {
            this.entity.protocol = protocol;
            return this;
        }

        public Builder connectorId(String connectorId) {
            this.entity.connectorId = connectorId;
            return this;
        }

        public Builder offer(ContractOffer offer) {
            this.entity.offer = offer;
            return this;
        }

        public Builder callbackAddresses(List<CallbackAddress> callbackAddresses) {
            this.entity.callbackAddresses = callbackAddresses;
            return this;
        }

        public NegotiateEdrRequest build() {
            Objects.requireNonNull(this.entity.protocol, "protocol should not be null");
            Objects.requireNonNull(this.entity.connectorAddress, "connector address should not be null");
            Objects.requireNonNull(this.entity.offer, "offer should not be null");
            return this.entity;
        }

        public static Builder newInstance() {
            return new Builder();
        }
    }
}

