/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.common.persistence;

import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.SetBucketLifecycleArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.Expiration;
import io.minio.messages.Item;
import io.minio.messages.LifecycleConfiguration;
import io.minio.messages.LifecycleRule;
import io.minio.messages.ResponseDate;
import io.minio.messages.RuleFilter;
import io.minio.messages.Status;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.eclipse.tractusx.irs.common.persistence.BlobPersistence;
import org.eclipse.tractusx.irs.common.persistence.BlobPersistenceException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioBlobPersistence
implements BlobPersistence {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MinioBlobPersistence.class);
    private final MinioClient minioClient;
    private final String bucketName;
    private final int daysToLive;

    public MinioBlobPersistence(String endpoint, String accessKey, String secretKey, String bucketName, int daysToLive) throws BlobPersistenceException {
        this(bucketName, MinioBlobPersistence.createClient(endpoint, accessKey, secretKey), daysToLive);
    }

    public MinioBlobPersistence(String bucketName, MinioClient client, int daysToLive) throws BlobPersistenceException {
        this.bucketName = bucketName;
        this.minioClient = client;
        this.daysToLive = daysToLive;
        try {
            this.createBucketIfNotExists(bucketName);
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new BlobPersistenceException("Encountered error while trying to create min.io client", e);
        }
    }

    public final void createBucketIfNotExists(String bucketName) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        if (!this.bucketExists(bucketName)) {
            this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
            if (this.daysToLive > 0) {
                this.setExpirationLifecycle(bucketName);
            }
        }
    }

    public final boolean bucketExists(String bucketName) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
    }

    @NotNull
    private static MinioClient createClient(String endpoint, String accessKey, String secretKey) {
        log.info("Building Minio client with url '{}'", (Object)endpoint);
        return MinioClient.builder().endpoint(endpoint).credentials(accessKey, secretKey).build();
    }

    private void setExpirationLifecycle(String bucketName) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        Expiration expiration = new Expiration((ResponseDate)null, Integer.valueOf(this.daysToLive), null);
        LifecycleRule rule = this.createExpirationRule(expiration);
        LifecycleConfiguration lifecycleConfig = new LifecycleConfiguration(List.of(rule));
        this.minioClient.setBucketLifecycle((SetBucketLifecycleArgs)((SetBucketLifecycleArgs.Builder)SetBucketLifecycleArgs.builder().bucket(bucketName)).config(lifecycleConfig).build());
    }

    private LifecycleRule createExpirationRule(Expiration expiration) {
        return new LifecycleRule(Status.ENABLED, null, expiration, new RuleFilter(""), null, null, null, null);
    }

    @Override
    public void putBlob(String targetBlobName, byte[] blob) throws BlobPersistenceException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(blob);
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.bucketName)).object(targetBlobName)).stream((InputStream)byteArrayInputStream, (long)byteArrayInputStream.available(), -1L).build());
            log.debug("Saving to bucket name {} with object name {}", (Object)this.bucketName, (Object)targetBlobName);
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new BlobPersistenceException("Encountered error while trying to store blob", e);
        }
    }

    @Override
    public Optional<byte[]> getBlob(String sourceBlobName) throws BlobPersistenceException {
        Optional<byte[]> optional;
        block12: {
            GetObjectResponse response;
            try {
                response = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.bucketName)).object(sourceBlobName)).build());
            }
            catch (ErrorResponseException e) {
                if ("NoSuchKey".equals(e.errorResponse().code())) {
                    return Optional.empty();
                }
                throw this.createLoadFailedException(e);
            }
            catch (InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                throw this.createLoadFailedException(e);
            }
            GetObjectResponse e = response;
            try {
                optional = Optional.ofNullable(response.readAllBytes());
                if (e == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (e != null) {
                        try {
                            e.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw this.createLoadFailedException(e2);
                }
            }
            e.close();
        }
        return optional;
    }

    @Override
    public Map<String, byte[]> getAllBlobs() throws BlobPersistenceException {
        Iterable<Result<Item>> items = this.getItems();
        ConcurrentHashMap<String, byte[]> result = new ConcurrentHashMap<String, byte[]>();
        for (Result<Item> item : items) {
            try {
                String objectName = ((Item)item.get()).objectName();
                GetObjectResponse response = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.bucketName)).object(objectName)).build());
                try {
                    result.put(objectName, response.readAllBytes());
                }
                finally {
                    if (response == null) continue;
                    response.close();
                }
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                throw this.createLoadFailedException(e);
            }
        }
        return result;
    }

    private BlobPersistenceException createLoadFailedException(Throwable cause) {
        return new BlobPersistenceException("Encountered error while trying to load blob", cause);
    }

    @Override
    public Collection<byte[]> findBlobByPrefix(String prefix) {
        Iterable results = this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().prefix(prefix).bucket(this.bucketName)).build());
        return StreamSupport.stream(results.spliterator(), false).flatMap(this::getItem).map(Item::objectName).flatMap(this::getBlobIfPresent).toList();
    }

    @Override
    public boolean delete(String sourceBlobName, List<String> processIds) throws BlobPersistenceException {
        try {
            this.deleteConnectedProcessesBlobs(processIds);
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.bucketName)).object(sourceBlobName)).build());
            return true;
        }
        catch (ErrorResponseException e) {
            if ("NoSuchKey".equals(e.errorResponse().code())) {
                return false;
            }
            throw new BlobPersistenceException("Encountered error while trying to delete blob", e);
        }
        catch (InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new BlobPersistenceException("Encountered error while trying to delete blob", e);
        }
    }

    private void deleteConnectedProcessesBlobs(List<String> processIds) {
        processIds.forEach(processId -> {
            try {
                this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.bucketName)).object(processId)).build());
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                log.info("No object data with process Id {} found", processId);
            }
        });
    }

    private Stream<byte[]> getBlobIfPresent(String sourceBlobName) {
        try {
            return this.getBlob(sourceBlobName).stream();
        }
        catch (BlobPersistenceException e) {
            log.error("Cannot find content for blob id {}", (Object)sourceBlobName);
            return Stream.empty();
        }
    }

    private Stream<Item> getItem(Result<Item> result) {
        try {
            return Stream.of((Item)result.get());
        }
        catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("Encountered error while trying to retrieve result content", e);
            return Stream.empty();
        }
    }

    private Iterable<Result<Item>> getItems() {
        return this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(this.bucketName)).build());
    }
}

