/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.common;

import io.github.resilience4j.retry.RetryRegistry;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class OutboundMeterRegistryService {
    private static final String ENDPOINT_SUBMODEL = "submodel";
    private static final String ENDPOINT_REGISTRY = "registry";
    private static final String TAG_ENDPOINT = "endpoint";
    private final Counter counterRetriesRegistry;
    private final Counter counterTimeoutsRegistry;
    private final MeterRegistry meterRegistry;
    private final Map<String, Counter> counterTimeoutsSubmodel;
    private final Map<String, Counter> counterRetriesSubmodel;

    public OutboundMeterRegistryService(MeterRegistry meterRegistry, RetryRegistry retryRegistry) {
        this.counterRetriesRegistry = Counter.builder((String)"http.requests.retries").description("The total number of retries.").tag(TAG_ENDPOINT, ENDPOINT_REGISTRY).register(meterRegistry);
        this.counterTimeoutsRegistry = Counter.builder((String)"http.requests.timeouts").description("The total number of timeouts.").tag(TAG_ENDPOINT, ENDPOINT_REGISTRY).register(meterRegistry);
        this.meterRegistry = meterRegistry;
        this.counterTimeoutsSubmodel = new HashMap<String, Counter>();
        this.counterRetriesSubmodel = new HashMap<String, Counter>();
        retryRegistry.retry(ENDPOINT_REGISTRY).getEventPublisher().onRetry(event -> this.counterRetriesRegistry.increment());
        retryRegistry.getAllRetries().stream().filter(retry -> !ENDPOINT_REGISTRY.equals(retry.getName())).forEach(retry -> retry.getEventPublisher().onRetry(event -> this.incrementSubmodelRetryCounter(retry.getName())));
    }

    public void incrementRegistryTimeoutCounter() {
        this.counterTimeoutsRegistry.increment();
    }

    public void incrementSubmodelTimeoutCounter(String target) {
        Counter counter = this.counterTimeoutsSubmodel.computeIfAbsent(target, key -> Counter.builder((String)"http.requests.timeouts").tag("host", key).description("The total number of timeouts.").tag(TAG_ENDPOINT, ENDPOINT_SUBMODEL).register(this.meterRegistry));
        counter.increment();
    }

    public void incrementSubmodelRetryCounter(String target) {
        Counter counter = this.counterRetriesSubmodel.computeIfAbsent(target, key -> Counter.builder((String)"http.requests.retries").tag("host", key).description("The total number of retries.").tag(TAG_ENDPOINT, ENDPOINT_SUBMODEL).register(this.meterRegistry));
        counter.increment();
    }

    @Generated
    public Counter getCounterRetriesRegistry() {
        return this.counterRetriesRegistry;
    }

    @Generated
    public Counter getCounterTimeoutsRegistry() {
        return this.counterTimeoutsRegistry;
    }

    @Generated
    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    @Generated
    public Map<String, Counter> getCounterTimeoutsSubmodel() {
        return this.counterTimeoutsSubmodel;
    }

    @Generated
    public Map<String, Counter> getCounterRetriesSubmodel() {
        return this.counterRetriesSubmodel;
    }
}

