/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.common.util.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultFinder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResultFinder.class);

    public <T> CompletableFuture<T> getFastestResult(List<CompletableFuture<T>> futures) {
        if (futures == null || futures.isEmpty()) {
            log.warn("Called getFastestResult with empty list of futures");
            return CompletableFuture.completedFuture(null);
        }
        log.debug("Trying to get fastest result from list of futures");
        CompletableFuture overallFuture = new CompletableFuture();
        ArrayList exceptions = new ArrayList();
        List<CompletableFuture<T>> futuresList = futures.stream().map(future -> ((CompletableFuture)future.exceptionally(ResultFinder.collectingExceptionsAndThrow(exceptions))).handle(ResultFinder.completingOnFirstSuccessful(overallFuture))).toList();
        CompletableFuture.allOf(ResultFinder.toArray(futuresList)).whenComplete((value, ex) -> {
            log.debug("All of the futures completed");
            if (ex != null) {
                log.warn("All failed: " + System.lineSeparator() + exceptions.stream().map(ExceptionUtils::getStackTrace).collect(Collectors.joining(System.lineSeparator())), ex);
                CompletionExceptions noneSuccessful = new CompletionExceptions("None successful");
                for (Throwable exception : exceptions) {
                    noneSuccessful.addSuppressed(exception);
                }
                overallFuture.completeExceptionally(noneSuccessful);
            } else {
                overallFuture.complete(null);
            }
        });
        return overallFuture;
    }

    private static <T> CompletableFuture<T>[] toArray(List<CompletableFuture<T>> handledFutures) {
        return handledFutures.toArray(new CompletableFuture[0]);
    }

    private static <T> BiFunction<T, Throwable, Boolean> completingOnFirstSuccessful(CompletableFuture<T> overallFuture) {
        return (value, throwable) -> {
            boolean currentFutureSuccessful;
            log.trace("value: '{}', throwable: {}", value, throwable);
            boolean notFinishedByOtherFuture = !overallFuture.isDone();
            log.debug("notFinishedByOtherFuture {} ", (Object)notFinishedByOtherFuture);
            boolean bl = currentFutureSuccessful = throwable == null && value != null;
            if (notFinishedByOtherFuture && currentFutureSuccessful) {
                log.debug("First future that completed successfully");
                overallFuture.complete(value);
                return true;
            }
            if (throwable != null) {
                log.warn("Exception occurred: " + throwable.getMessage(), throwable);
                throw new CompletionException(throwable.getMessage(), (Throwable)throwable);
            }
            return false;
        };
    }

    private static <T> Function<Throwable, T> collectingExceptionsAndThrow(List<Throwable> exceptions) {
        return t -> {
            log.error("Exception occurred: " + t.getMessage(), t);
            exceptions.add((Throwable)t);
            throw new CompletionException((Throwable)t);
        };
    }

    public static class CompletionExceptions
    extends CompletionException {
        public CompletionExceptions(String msg) {
            super(msg);
        }

        @Override
        @Generated
        public String toString() {
            return "ResultFinder.CompletionExceptions()";
        }
    }
}

