/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.common.auth;

import java.util.Collections;
import java.util.List;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public final class SecurityHelperService {
    public boolean isAdmin() {
        return this.getIrsRoles().contains("admin_irs");
    }

    private List<String> getIrsRoles() {
        Authentication authentication = this.getAuthenticationFromSecurityContext();
        if (authentication instanceof AbstractAuthenticationToken) {
            AbstractAuthenticationToken authenticationToken = (AbstractAuthenticationToken)authentication;
            return authenticationToken.getAuthorities().stream().map(GrantedAuthority::getAuthority).toList();
        }
        return Collections.emptyList();
    }

    private Authentication getAuthenticationFromSecurityContext() {
        return SecurityContextHolder.getContext().getAuthentication();
    }
}

