/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.callback.CallbackAddress;
import org.eclipse.tractusx.irs.edc.client.EdcConfiguration;
import org.eclipse.tractusx.irs.edc.client.EdcControlPlaneClient;
import org.eclipse.tractusx.irs.edc.client.cache.endpointdatareference.EndpointDataReferenceStatus;
import org.eclipse.tractusx.irs.edc.client.exceptions.ContractNegotiationException;
import org.eclipse.tractusx.irs.edc.client.exceptions.TransferProcessException;
import org.eclipse.tractusx.irs.edc.client.exceptions.UsagePolicyExpiredException;
import org.eclipse.tractusx.irs.edc.client.exceptions.UsagePolicyPermissionException;
import org.eclipse.tractusx.irs.edc.client.model.CatalogItem;
import org.eclipse.tractusx.irs.edc.client.model.ContractOffer;
import org.eclipse.tractusx.irs.edc.client.model.NegotiationRequest;
import org.eclipse.tractusx.irs.edc.client.model.NegotiationResponse;
import org.eclipse.tractusx.irs.edc.client.model.Response;
import org.eclipse.tractusx.irs.edc.client.model.TransferProcessRequest;
import org.eclipse.tractusx.irs.edc.client.model.TransferProcessResponse;
import org.eclipse.tractusx.irs.edc.client.policy.PolicyCheckerService;
import org.eclipse.tractusx.irs.edc.client.util.Masker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="irsEdcClientContractNegotiationService")
public class ContractNegotiationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContractNegotiationService.class);
    public static final String EDC_PROTOCOL = "dataspace-protocol-http";
    public static final String EVENT_TRANSFER_PROCESS_STARTED = "transfer.process.started";
    public static final String HTTP_DATA_PULL = "HttpData-PULL";
    private final EdcControlPlaneClient edcControlPlaneClient;
    private final PolicyCheckerService policyCheckerService;
    private final EdcConfiguration config;

    public TransferProcessResponse negotiate(String providerConnectorUrl, CatalogItem catalogItem, EndpointDataReferenceStatus endpointDataReferenceStatus, String bpn) throws ContractNegotiationException, UsagePolicyPermissionException, TransferProcessException, UsagePolicyExpiredException {
        String contractAgreementId;
        EndpointDataReferenceStatus resultEndpointDataReferenceStatus;
        if (endpointDataReferenceStatus == null) {
            log.info("Missing information about endpoint data reference from storage, setting token status to REQUIRED_NEW.");
            resultEndpointDataReferenceStatus = new EndpointDataReferenceStatus(null, EndpointDataReferenceStatus.TokenStatus.REQUIRED_NEW);
        } else {
            resultEndpointDataReferenceStatus = endpointDataReferenceStatus;
        }
        switch (resultEndpointDataReferenceStatus.tokenStatus()) {
            case REQUIRED_NEW: {
                CompletableFuture<NegotiationResponse> responseFuture = this.startNewNegotiation(providerConnectorUrl, catalogItem, bpn);
                NegotiationResponse negotiationResponse = Objects.requireNonNull(this.getNegotiationResponse(responseFuture));
                contractAgreementId = negotiationResponse.getContractAgreementId();
                break;
            }
            case EXPIRED: {
                contractAgreementId = resultEndpointDataReferenceStatus.endpointDataReference().getContractId();
                log.info("Cached endpoint data reference has expired token. Refreshing token without new contract negotiation for contractAgreementId: {}", (Object)Masker.mask(contractAgreementId));
                break;
            }
            case VALID: {
                throw new IllegalStateException("Token is present and valid. Contract negotiation should not be started.");
            }
            default: {
                throw new IllegalStateException("Unknown token status.");
            }
        }
        TransferProcessRequest transferProcessRequest = this.createTransferProcessRequest(providerConnectorUrl, catalogItem, contractAgreementId);
        Response transferProcessId = this.edcControlPlaneClient.startTransferProcess(transferProcessRequest);
        CompletableFuture<TransferProcessResponse> transferProcessFuture = this.edcControlPlaneClient.getTransferProcess(transferProcessId);
        TransferProcessResponse transferProcessResponse = Objects.requireNonNull(this.getTransferProcessResponse(transferProcessFuture));
        log.info("Transfer process completed for transferProcessId: {}", (Object)transferProcessResponse.getResponseId());
        return transferProcessResponse;
    }

    private CompletableFuture<NegotiationResponse> startNewNegotiation(String providerConnectorUrl, CatalogItem catalogItem, String bpn) throws UsagePolicyPermissionException, UsagePolicyExpiredException {
        log.info("Staring new contract negotiation.");
        if (!this.policyCheckerService.isValid(catalogItem.getPolicy(), bpn)) {
            log.warn("Policy was not allowed, canceling negotiation.");
            throw new UsagePolicyPermissionException(this.policyCheckerService.getValidStoredPolicies(catalogItem.getConnectorId()), catalogItem.getPolicy(), catalogItem.getConnectorId());
        }
        if (this.policyCheckerService.isExpired(catalogItem.getPolicy(), bpn)) {
            log.warn("Policy is expired, canceling negotiation.");
            throw new UsagePolicyExpiredException(this.policyCheckerService.getValidStoredPolicies(catalogItem.getConnectorId()), catalogItem.getPolicy(), catalogItem.getConnectorId());
        }
        NegotiationRequest negotiationRequest = this.createNegotiationRequestFromCatalogItem(providerConnectorUrl, catalogItem);
        Response negotiationId = this.edcControlPlaneClient.startNegotiations(negotiationRequest);
        log.info("Fetch negotiation id: {}", (Object)negotiationId.getResponseId());
        return this.edcControlPlaneClient.getNegotiationResult(negotiationId);
    }

    private TransferProcessRequest createTransferProcessRequest(String providerConnectorUrl, CatalogItem catalogItem, String agreementId) {
        DataAddress destination = DataAddress.Builder.newInstance().type("HttpProxy").build();
        TransferProcessRequest.TransferProcessRequestBuilder transferProcessRequestBuilder = TransferProcessRequest.builder().protocol(EDC_PROTOCOL).managedResources(false).connectorId(catalogItem.getConnectorId()).counterPartyAddress(providerConnectorUrl).transferType(HTTP_DATA_PULL).contractId(agreementId).assetId(catalogItem.getAssetPropId()).dataDestination(destination);
        if (StringUtils.isNotBlank((CharSequence)this.config.getCallbackUrl())) {
            log.info("Setting EDR callback to {}", (Object)this.config.getCallbackUrl());
            transferProcessRequestBuilder.privateProperties(Map.of("receiverHttpEndpoint", this.config.getCallbackUrl()));
            CallbackAddress callbackAddress = CallbackAddress.Builder.newInstance().uri(this.config.getCallbackUrl()).events(Set.of(EVENT_TRANSFER_PROCESS_STARTED)).build();
            transferProcessRequestBuilder.callbackAddresses(List.of(callbackAddress));
        }
        return transferProcessRequestBuilder.build();
    }

    private NegotiationRequest createNegotiationRequestFromCatalogItem(String providerConnectorUrl, CatalogItem catalogItem) {
        return NegotiationRequest.builder().counterPartyAddress(providerConnectorUrl).counterPartyId(catalogItem.getConnectorId()).protocol(EDC_PROTOCOL).contractOffer(ContractOffer.fromPolicy(catalogItem.getPolicy(), catalogItem.getOfferId(), catalogItem.getAssetPropId(), catalogItem.getConnectorId())).build();
    }

    private NegotiationResponse getNegotiationResponse(CompletableFuture<NegotiationResponse> negotiationResponse) throws ContractNegotiationException {
        try {
            return negotiationResponse.get(this.config.getAsyncTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException | TimeoutException e) {
            throw new ContractNegotiationException(e);
        }
        return null;
    }

    private TransferProcessResponse getTransferProcessResponse(CompletableFuture<TransferProcessResponse> transferProcessResponse) throws TransferProcessException {
        try {
            return transferProcessResponse.get(this.config.getAsyncTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException | TimeoutException e) {
            throw new TransferProcessException(e);
        }
        return null;
    }

    @Generated
    public ContractNegotiationService(EdcControlPlaneClient edcControlPlaneClient, PolicyCheckerService policyCheckerService, EdcConfiguration config) {
        this.edcControlPlaneClient = edcControlPlaneClient;
        this.policyCheckerService = policyCheckerService;
        this.config = config;
    }
}

