/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.ListUtils;
import org.eclipse.edc.catalog.spi.Catalog;
import org.eclipse.edc.catalog.spi.CatalogRequest;
import org.eclipse.edc.catalog.spi.Dataset;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.tractusx.irs.edc.client.EdcConfiguration;
import org.eclipse.tractusx.irs.edc.client.EdcControlPlaneClient;
import org.eclipse.tractusx.irs.edc.client.model.CatalogItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="irsEdcClientEdcCatalogFacade")
public class EDCCatalogFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EDCCatalogFacade.class);
    public static final String NAMESPACE_DSPACE_PARTICIPANT_ID = "https://w3id.org/dspace/v0.8/participantId";
    private final EdcControlPlaneClient controlPlaneClient;
    private final EdcConfiguration config;

    private static CatalogItem createCatalogItem(Catalog pageableCatalog, Dataset dataset) {
        boolean maxNumberOfOffers = true;
        if (dataset.getOffers().size() > 1) {
            log.warn("Catalog Offer contains more than one Policy. Using the first one");
        }
        Map.Entry stringPolicyEntry = (Map.Entry)dataset.getOffers().entrySet().stream().findFirst().orElseThrow();
        CatalogItem.CatalogItemBuilder builder = CatalogItem.builder().itemId(pageableCatalog.getId()).offerId((String)stringPolicyEntry.getKey()).assetPropId(dataset.getId()).policy((Policy)stringPolicyEntry.getValue()).connectorId(EDCCatalogFacade.getParticipantId(pageableCatalog));
        return builder.build();
    }

    private static String getParticipantId(Catalog catalog) {
        if (catalog.getProperties().containsKey("https://w3id.org/edc/v0.0.1/ns/participantId")) {
            return catalog.getProperties().get("https://w3id.org/edc/v0.0.1/ns/participantId").toString();
        }
        if (catalog.getProperties().containsKey(NAMESPACE_DSPACE_PARTICIPANT_ID)) {
            return catalog.getProperties().get(NAMESPACE_DSPACE_PARTICIPANT_ID).toString();
        }
        return catalog.getParticipantId();
    }

    public List<CatalogItem> fetchCatalogItems(CatalogRequest catalogRequest) {
        Catalog catalog = this.controlPlaneClient.getCatalog(catalogRequest);
        return EDCCatalogFacade.mapToCatalogItems(catalog);
    }

    private static List<CatalogItem> mapToCatalogItems(Catalog catalog) {
        return ListUtils.emptyIfNull((List)catalog.getDatasets()).stream().map(dataset -> {
            Map.Entry offer = (Map.Entry)dataset.getOffers().entrySet().stream().findFirst().orElseThrow();
            Policy policy = ((Policy)offer.getValue()).toBuilder().assigner(EDCCatalogFacade.getParticipantId(catalog)).target(dataset.getId()).build();
            return CatalogItem.builder().itemId(dataset.getId()).assetPropId(dataset.getId()).offerId((String)offer.getKey()).policy(policy).connectorId(EDCCatalogFacade.getParticipantId(catalog)).build();
        }).toList();
    }

    @Deprecated(since="5.4.1")
    public List<CatalogItem> fetchCatalogItemsUntilMatch(String connectorUrl, String target, String bpn) {
        int offset = 0;
        int pageSize = this.config.getControlplane().getCatalogPageSize();
        log.info("Get catalog from EDC provider.");
        Catalog pageableCatalog = this.controlPlaneClient.getCatalog(connectorUrl, offset, bpn);
        ArrayList datasets = new ArrayList(pageableCatalog.getDatasets());
        boolean isLastPage = pageableCatalog.getDatasets().size() < pageSize;
        boolean isTheSamePage = false;
        Optional<Dataset> optionalContractOffer = this.findOfferIfExist(target, pageableCatalog);
        while (!isLastPage && !isTheSamePage && optionalContractOffer.isEmpty()) {
            Catalog newPageableCatalog = this.controlPlaneClient.getCatalog(connectorUrl, offset += pageSize, bpn);
            isTheSamePage = this.theSameCatalog(pageableCatalog, newPageableCatalog);
            isLastPage = newPageableCatalog.getDatasets().size() < pageSize;
            optionalContractOffer = this.findOfferIfExist(target, newPageableCatalog);
            if (isTheSamePage) continue;
            datasets.addAll(newPageableCatalog.getDatasets());
        }
        log.info("Search for offer for asset id: {}", (Object)target);
        return datasets.stream().map(dataset -> EDCCatalogFacade.createCatalogItem(pageableCatalog, dataset)).toList();
    }

    @Deprecated(since="5.0.0")
    public List<CatalogItem> fetchCatalogById(String connectorUrl, String target, String bpn) {
        return this.fetchCatalogByFilter(connectorUrl, "https://w3id.org/edc/v0.0.1/ns/id", target, bpn);
    }

    public List<CatalogItem> fetchCatalogByFilter(String connectorUrl, String key, String value, String bpn) {
        Catalog catalog = this.controlPlaneClient.getCatalogWithFilter(connectorUrl, key, value, bpn);
        return EDCCatalogFacade.mapToCatalogItems(catalog);
    }

    private Optional<Dataset> findOfferIfExist(String target, Catalog catalog) {
        return ListUtils.emptyIfNull((List)catalog.getDatasets()).stream().filter(dataset -> target.equals(dataset.getId())).findFirst();
    }

    private boolean theSameCatalog(Catalog pageableCatalog, Catalog newPageableCatalog) {
        Set previousOffers = ListUtils.emptyIfNull((List)pageableCatalog.getDatasets()).stream().map(Dataset::getId).collect(Collectors.toSet());
        Set nextOffers = ListUtils.emptyIfNull((List)newPageableCatalog.getDatasets()).stream().map(Dataset::getId).collect(Collectors.toSet());
        return previousOffers.equals(nextOffers);
    }

    @Generated
    public EDCCatalogFacade(EdcControlPlaneClient controlPlaneClient, EdcConfiguration config) {
        this.controlPlaneClient = controlPlaneClient;
        this.config = config;
    }
}

