/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client;

import io.swagger.v3.oas.annotations.Hidden;
import java.util.NoSuchElementException;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.eclipse.tractusx.irs.data.JsonParseException;
import org.eclipse.tractusx.irs.data.StringMapper;
import org.eclipse.tractusx.irs.edc.client.EndpointDataReferenceStorage;
import org.eclipse.tractusx.irs.edc.client.exceptions.EdcClientException;
import org.eclipse.tractusx.irs.edc.client.model.edr.DataAddress;
import org.eclipse.tractusx.irs.edc.client.model.edr.EndpointDataReferenceCallback;
import org.eclipse.tractusx.irs.edc.client.model.edr.Properties;
import org.eclipse.tractusx.irs.edc.client.model.edr.TransferProcessCallbackPayload;
import org.eclipse.tractusx.irs.edc.client.util.Masker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="irsEdcClientEdcCallbackController")
@RequestMapping(value={"${irs-edc-client.callback.mapping}"})
@Hidden
public class EdcCallbackController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdcCallbackController.class);
    private final EndpointDataReferenceStorage storage;

    @PostMapping
    public void receiveEdcCallback(@RequestBody String endpointDataReferenceCallback) {
        try {
            EndpointDataReference endpointDataReference = EdcCallbackController.mapToEndpointDataReference(endpointDataReferenceCallback);
            log.debug("Received EndpointDataReference: {}", (Object)StringMapper.mapToString((Object)endpointDataReference));
            log.debug("Received EndpointDataReference with ID {} and endpoint {}", (Object)endpointDataReference.getId(), (Object)endpointDataReference.getEndpoint());
            String contractId = endpointDataReference.getContractId();
            this.storeEdr(contractId, endpointDataReference);
        }
        catch (EdcClientException e) {
            log.error("Could not deserialize Endpoint Data Reference {}", (Object)endpointDataReferenceCallback);
        }
    }

    private static EndpointDataReference mapToEndpointDataReference(String endpointDataReference) throws EdcClientException {
        try {
            EndpointDataReferenceCallback endpointDataReferenceCallback = (EndpointDataReferenceCallback)StringMapper.mapFromString((String)endpointDataReference, EndpointDataReferenceCallback.class);
            TransferProcessCallbackPayload payload = Optional.ofNullable(endpointDataReferenceCallback.getPayload()).orElseThrow();
            DataAddress dataAddress = Optional.ofNullable(payload.dataAddress()).orElseThrow();
            Properties properties = Optional.ofNullable(dataAddress.properties()).orElseThrow();
            EndpointDataReference dataReference = EndpointDataReference.Builder.newInstance().contractId(properties.agreementId()).id(properties.processId()).authKey("Authorization").authCode(properties.authorization()).endpoint(properties.endpoint()).build();
            return dataReference;
        }
        catch (NoSuchElementException | JsonParseException e) {
            throw new EdcClientException(e);
        }
    }

    private void storeEdr(String contractId, EndpointDataReference dataReference) {
        this.storage.put(contractId, dataReference);
        log.info("Endpoint Data Reference received and cached for agreement: {}", (Object)Masker.mask(contractId));
    }

    @Generated
    public EdcCallbackController(EndpointDataReferenceStorage storage) {
        this.storage = storage;
    }
}

