/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.eclipse.edc.catalog.spi.Catalog;
import org.eclipse.edc.catalog.spi.CatalogRequest;
import org.eclipse.edc.spi.query.Criterion;
import org.eclipse.edc.spi.query.QuerySpec;
import org.eclipse.tractusx.irs.edc.client.AsyncPollingService;
import org.eclipse.tractusx.irs.edc.client.EdcConfiguration;
import org.eclipse.tractusx.irs.edc.client.model.NegotiationRequest;
import org.eclipse.tractusx.irs.edc.client.model.NegotiationResponse;
import org.eclipse.tractusx.irs.edc.client.model.NegotiationState;
import org.eclipse.tractusx.irs.edc.client.model.Response;
import org.eclipse.tractusx.irs.edc.client.model.TransferProcessRequest;
import org.eclipse.tractusx.irs.edc.client.model.TransferProcessResponse;
import org.eclipse.tractusx.irs.edc.client.transformer.EdcTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service(value="irsEdcClientEdcControlPlaneClient")
public class EdcControlPlaneClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdcControlPlaneClient.class);
    public static final String STATUS_FINALIZED = "FINALIZED";
    public static final String STATUS_COMPLETED = "COMPLETED";
    public static final String STATUS_STARTED = "STARTED";
    public static final String STATUS_ERROR = "ERROR";
    public static final String DATASPACE_PROTOCOL_HTTP = "dataspace-protocol-http";
    public static final String STATUS_TERMINATED = "TERMINATED";
    private final RestTemplate edcRestTemplate;
    private final AsyncPollingService pollingService;
    private final EdcConfiguration config;
    private final EdcTransformer edcTransformer;

    public EdcControlPlaneClient(@Qualifier(value="edcClientRestTemplate") RestTemplate edcRestTemplate, AsyncPollingService pollingService, EdcConfiguration config, EdcTransformer edcTransformer) {
        this.edcRestTemplate = edcRestTemplate;
        this.pollingService = pollingService;
        this.config = config;
        this.edcTransformer = edcTransformer;
    }

    private static String getResponseBody(ResponseEntity<String> response) {
        String responseBody = "";
        if (response.hasBody() && response.getBody() != null) {
            responseBody = (String)response.getBody();
        }
        return responseBody;
    }

    @Deprecated
    Catalog getCatalog(String providerConnectorUrl, int offset, String bpn) {
        int limit = this.config.getControlplane().getCatalogPageSize();
        CatalogRequest request = this.buildCatalogRequest(offset, providerConnectorUrl, limit, bpn);
        return this.getCatalog(request);
    }

    Catalog getCatalog(CatalogRequest requestBody) {
        EdcConfiguration.ControlplaneConfig.EndpointConfig endpoint = this.config.getControlplane().getEndpoint();
        String url = endpoint.getData() + endpoint.getCatalog();
        String requestJson = this.edcTransformer.transformCatalogRequestToJson(requestBody).toString();
        log.info("Requesting catalog with payload: {}", (Object)requestJson);
        ResponseEntity response = this.edcRestTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)requestJson, (MultiValueMap)this.headers()), String.class, new Object[0]);
        String catalog = EdcControlPlaneClient.getResponseBody((ResponseEntity<String>)response);
        return this.edcTransformer.transformCatalog(catalog, StandardCharsets.UTF_8);
    }

    private CatalogRequest buildCatalogRequest(int offset, String providerUrl, int limit, String bpn) {
        QuerySpec.Builder querySpec = QuerySpec.Builder.newInstance().offset(Integer.valueOf(offset));
        if (this.config.getControlplane().getCatalogPageSize() > 0) {
            querySpec.limit(Integer.valueOf(limit));
        }
        return CatalogRequest.Builder.newInstance().counterPartyAddress(providerUrl).counterPartyId(bpn).protocol(DATASPACE_PROTOCOL_HTTP).querySpec(querySpec.build()).build();
    }

    Catalog getCatalogWithFilter(String providerConnectorUrl, String key, String value, String bpn) {
        QuerySpec querySpec = QuerySpec.Builder.newInstance().filter(new Criterion((Object)key, "=", (Object)value)).build();
        CatalogRequest catalogRequest = CatalogRequest.Builder.newInstance().counterPartyAddress(providerConnectorUrl).counterPartyId(bpn).protocol(DATASPACE_PROTOCOL_HTTP).querySpec(querySpec).build();
        return this.getCatalog(catalogRequest);
    }

    Response startNegotiations(NegotiationRequest request) {
        EdcConfiguration.ControlplaneConfig.EndpointConfig endpoint = this.config.getControlplane().getEndpoint();
        String url = endpoint.getData() + endpoint.getContractNegotiation();
        String jsonObject = this.edcTransformer.transformNegotiationRequestToJson(request).toString();
        return (Response)this.edcRestTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)jsonObject, (MultiValueMap)this.headers()), Response.class, new Object[0]).getBody();
    }

    CompletableFuture<NegotiationResponse> getNegotiationResult(Response negotiationId) {
        HttpEntity objectHttpEntity = new HttpEntity(null, (MultiValueMap)this.headers());
        return this.pollingService.createJob().action(() -> {
            log.info("Check negotiations status");
            NegotiationState negotiationState = this.getContractNegotiationState(negotiationId, (HttpEntity<Object>)objectHttpEntity);
            log.info("Response status of negotiation: {}", (Object)negotiationState);
            if (negotiationState != null) {
                return switch (negotiationState.getState()) {
                    case STATUS_FINALIZED -> Optional.of(this.getContractNegotiationResponse(negotiationId, (HttpEntity<Object>)objectHttpEntity));
                    case STATUS_ERROR -> throw new IllegalStateException("NegotiationResponse with id " + this.getContractNegotiationResponse(negotiationId, (HttpEntity<Object>)objectHttpEntity).getResponseId() + " is in state ERROR");
                    case STATUS_TERMINATED -> throw new IllegalStateException("NegotiationResponse with id " + this.getContractNegotiationResponse(negotiationId, (HttpEntity<Object>)objectHttpEntity).getResponseId() + " is in state TERMINATED");
                    default -> Optional.empty();
                };
            }
            return Optional.empty();
        }).description("wait for negotiation confirmation").timeToLive(this.config.getControlplane().getRequestTtl()).build().schedule();
    }

    private NegotiationState getContractNegotiationState(Response negotiationId, HttpEntity<Object> objectHttpEntity) {
        EdcConfiguration.ControlplaneConfig.EndpointConfig endpoint = this.config.getControlplane().getEndpoint();
        String url = endpoint.getData() + endpoint.getContractNegotiation() + "/" + negotiationId.getResponseId() + endpoint.getStateSuffix();
        return (NegotiationState)this.edcRestTemplate.exchange(url, HttpMethod.GET, objectHttpEntity, NegotiationState.class, new Object[0]).getBody();
    }

    private NegotiationResponse getContractNegotiationResponse(Response negotiationId, HttpEntity<Object> objectHttpEntity) {
        EdcConfiguration.ControlplaneConfig.EndpointConfig endpoint = this.config.getControlplane().getEndpoint();
        String url = endpoint.getData() + endpoint.getContractNegotiation() + "/" + negotiationId.getResponseId();
        return (NegotiationResponse)this.edcRestTemplate.exchange(url, HttpMethod.GET, objectHttpEntity, NegotiationResponse.class, new Object[0]).getBody();
    }

    Response startTransferProcess(TransferProcessRequest request) {
        String jsonObject = this.edcTransformer.transformTransferProcessRequestToJson(request).toString();
        EdcConfiguration.ControlplaneConfig.EndpointConfig endpoint = this.config.getControlplane().getEndpoint();
        String url = endpoint.getData() + endpoint.getTransferProcess();
        return (Response)this.edcRestTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)jsonObject, (MultiValueMap)this.headers()), Response.class, new Object[0]).getBody();
    }

    CompletableFuture<TransferProcessResponse> getTransferProcess(Response transferProcessId) {
        HttpEntity objectHttpEntity = new HttpEntity(null, (MultiValueMap)this.headers());
        return this.pollingService.createJob().action(() -> {
            log.info("Check Transfer Process status");
            NegotiationState transferProcessState = this.getTransferProcessState(transferProcessId, (HttpEntity<Object>)objectHttpEntity);
            log.info("Response status of Transfer Process: {}", (Object)transferProcessState);
            if (transferProcessState != null) {
                return switch (transferProcessState.getState()) {
                    case STATUS_COMPLETED, STATUS_STARTED -> Optional.of(this.getTransferProcessResponse(transferProcessId, (HttpEntity<Object>)objectHttpEntity));
                    case STATUS_ERROR -> throw new IllegalStateException("TransferProcessResponse with id " + this.getTransferProcessResponse(transferProcessId, (HttpEntity<Object>)objectHttpEntity).getResponseId() + " is in state ERROR");
                    case STATUS_TERMINATED -> throw new IllegalStateException("TransferProcessResponse with id " + this.getTransferProcessResponse(transferProcessId, (HttpEntity<Object>)objectHttpEntity).getResponseId() + " is in state TERMINATED");
                    default -> Optional.empty();
                };
            }
            return Optional.empty();
        }).description("wait for transfer process completion").timeToLive(this.config.getControlplane().getRequestTtl()).build().schedule();
    }

    private NegotiationState getTransferProcessState(Response transferProcessId, HttpEntity<Object> objectHttpEntity) {
        EdcConfiguration.ControlplaneConfig.EndpointConfig endpoint = this.config.getControlplane().getEndpoint();
        String url = endpoint.getData() + endpoint.getTransferProcess() + "/" + transferProcessId.getResponseId() + endpoint.getStateSuffix();
        return (NegotiationState)this.edcRestTemplate.exchange(url, HttpMethod.GET, objectHttpEntity, NegotiationState.class, new Object[0]).getBody();
    }

    private TransferProcessResponse getTransferProcessResponse(Response transferProcessId, HttpEntity<Object> objectHttpEntity) {
        EdcConfiguration.ControlplaneConfig.EndpointConfig endpoint = this.config.getControlplane().getEndpoint();
        String url = endpoint.getData() + endpoint.getTransferProcess() + "/" + transferProcessId.getResponseId();
        return (TransferProcessResponse)this.edcRestTemplate.exchange(url, HttpMethod.GET, objectHttpEntity, TransferProcessResponse.class, new Object[0]).getBody();
    }

    private HttpHeaders headers() {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        headers.setContentType(MediaType.APPLICATION_JSON);
        String apiKeyHeader = this.config.getControlplane().getApiKey().getHeader();
        if (apiKeyHeader != null) {
            headers.add(apiKeyHeader, this.config.getControlplane().getApiKey().getSecret());
        }
        return headers;
    }
}

