/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.eclipse.tractusx.irs.data.StringMapper;
import org.eclipse.tractusx.irs.edc.client.model.notification.EdcNotification;
import org.eclipse.tractusx.irs.edc.client.model.notification.EdcNotificationResponse;
import org.eclipse.tractusx.irs.edc.client.model.notification.NotificationContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service(value="irsEdcClientEdcDataPlaneClient")
public class EdcDataPlaneClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdcDataPlaneClient.class);
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("\\{\"data\":\"(?<embeddedData>.*)\"\\}");
    private final RestTemplate edcRestTemplate;

    public EdcDataPlaneClient(@Qualifier(value="edcClientRestTemplate") RestTemplate edcRestTemplate) {
        this.edcRestTemplate = edcRestTemplate;
    }

    public String getData(EndpointDataReference dataReference, String submodelDataplaneUrl) {
        String response = (String)this.edcRestTemplate.exchange(submodelDataplaneUrl, HttpMethod.GET, new HttpEntity(null, (MultiValueMap)this.headers(dataReference)), String.class, new Object[0]).getBody();
        log.info("Extracting raw embeddedData from EDC data plane response");
        return this.extractEmbeddedData(response);
    }

    public EdcNotificationResponse sendData(EndpointDataReference dataReference, EdcNotification<NotificationContent> notification) {
        String url = dataReference.getEndpoint();
        HttpHeaders headers = this.headers(dataReference);
        headers.setContentType(MediaType.APPLICATION_JSON);
        ResponseEntity response = this.edcRestTemplate.exchange(url, HttpMethod.POST, new HttpEntity((Object)StringMapper.mapToString(notification), (MultiValueMap)headers), String.class, new Object[0]);
        log.info("Call to {} returned with status code {}", (Object)url, (Object)response.getStatusCode());
        return () -> response.getStatusCode().is2xxSuccessful();
    }

    private HttpHeaders headers(EndpointDataReference dataReference) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        String authKey = dataReference.getAuthKey();
        if (authKey != null) {
            headers.add(authKey, dataReference.getAuthCode());
        }
        return headers;
    }

    private String extractEmbeddedData(String response) {
        String modifiedResponse = response;
        Matcher dataMatcher = RESPONSE_PATTERN.matcher(modifiedResponse);
        while (dataMatcher.matches()) {
            modifiedResponse = dataMatcher.group("embeddedData");
            modifiedResponse = modifiedResponse.replace("\\\"", "\"").replace("\\\\", "\\");
            dataMatcher = RESPONSE_PATTERN.matcher(response);
        }
        return modifiedResponse;
    }
}

