/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.eclipse.tractusx.irs.data.StringMapper;
import org.eclipse.tractusx.irs.edc.client.AsyncPollingService;
import org.eclipse.tractusx.irs.edc.client.ContractNegotiationService;
import org.eclipse.tractusx.irs.edc.client.EDCCatalogFacade;
import org.eclipse.tractusx.irs.edc.client.EdcConfiguration;
import org.eclipse.tractusx.irs.edc.client.OngoingNegotiationStorage;
import org.eclipse.tractusx.irs.edc.client.cache.endpointdatareference.EndpointDataReferenceCacheService;
import org.eclipse.tractusx.irs.edc.client.cache.endpointdatareference.EndpointDataReferenceStatus;
import org.eclipse.tractusx.irs.edc.client.exceptions.EdcClientException;
import org.eclipse.tractusx.irs.edc.client.model.CatalogItem;
import org.eclipse.tractusx.irs.edc.client.model.TransferProcessResponse;
import org.eclipse.tractusx.irs.edc.client.util.Masker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

@Service
public class EdcOrchestrator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdcOrchestrator.class);
    private final EdcConfiguration config;
    private final ContractNegotiationService contractNegotiationService;
    private final AsyncPollingService pollingService;
    private final EDCCatalogFacade catalogFacade;
    private final EndpointDataReferenceCacheService endpointDataReferenceCacheService;
    private final ExecutorService executorService;
    private final OngoingNegotiationStorage ongoingNegotiationStorage;

    public EdcOrchestrator(EdcConfiguration config, ContractNegotiationService contractNegotiationService, AsyncPollingService pollingService, EDCCatalogFacade catalogFacade, EndpointDataReferenceCacheService endpointDataReferenceCacheService, ExecutorService fixedThreadPoolExecutorService, OngoingNegotiationStorage ongoingNegotiationStorage) {
        this.config = config;
        this.contractNegotiationService = contractNegotiationService;
        this.pollingService = pollingService;
        this.catalogFacade = catalogFacade;
        this.endpointDataReferenceCacheService = endpointDataReferenceCacheService;
        this.executorService = fixedThreadPoolExecutorService;
        this.ongoingNegotiationStorage = ongoingNegotiationStorage;
    }

    private static void stopWatchOnEdcTask(StopWatch stopWatch) {
        stopWatch.stop();
        log.info("EDC Task '{}' took {} ms", (Object)stopWatch.getLastTaskName(), (Object)stopWatch.getLastTaskTimeMillis());
    }

    public List<CatalogItem> getCatalogItems(String dspEndpointAddress, String filterKey, String filterValue, String bpn) throws EdcClientException {
        CompletableFuture<Object> objectCompletableFuture;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("Get Catalog Items");
        try {
            objectCompletableFuture = CompletableFuture.supplyAsync(() -> {
                List<CatalogItem> contractOffers = this.catalogFacade.fetchCatalogByFilter(dspEndpointAddress, filterKey, filterValue, bpn);
                log.debug("Retrieved catalog items: '{}'", (Object)StringMapper.mapToString(contractOffers));
                EdcOrchestrator.stopWatchOnEdcTask(stopWatch);
                return contractOffers;
            }, this.executorService);
        }
        catch (Exception e) {
            objectCompletableFuture = CompletableFuture.failedFuture(new EdcClientException("Error retrieving catalog items.", e));
        }
        try {
            return (List)objectCompletableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new EdcClientException("Error retrieving catalog items.", e);
        }
    }

    public CatalogItem getCatalogItem(String dspEndpointAddress, String assetId, String bpn) throws EdcClientException {
        List<CatalogItem> catalogItems = this.getCatalogItems(dspEndpointAddress, "https://w3id.org/edc/v0.0.1/ns/id", assetId, bpn);
        return (CatalogItem)catalogItems.stream().findFirst().orElseThrow(() -> new EdcClientException("Catalog is empty for endpointAddress '%s' filterKey '%s', filterValue '%s'".formatted(dspEndpointAddress, "https://w3id.org/edc/v0.0.1/ns/id", assetId)));
    }

    public CompletableFuture<EndpointDataReference> getEndpointDataReference(String dspEndpointAddress, CatalogItem catalogItem) throws EdcClientException {
        return this.getEndpointDataReference(dspEndpointAddress, catalogItem.getItemId(), catalogItem.getConnectorId(), Optional.of(catalogItem));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<EndpointDataReference> getEndpointDataReference(String dspEndpointAddress, String assetId, String bpn, Optional<CatalogItem> optionalCatalogItem) throws EdcClientException {
        log.info("Retrieving endpoint data reference from cache for asset id: '{}' on edc: '{}'", (Object)assetId, (Object)dspEndpointAddress);
        String storageId = assetId + dspEndpointAddress;
        OngoingNegotiationStorage ongoingNegotiationStorage = this.ongoingNegotiationStorage;
        synchronized (ongoingNegotiationStorage) {
            CatalogItem catalogItem;
            EndpointDataReferenceStatus cachedEdr = this.endpointDataReferenceCacheService.getEndpointDataReference(storageId);
            if (EndpointDataReferenceStatus.TokenStatus.VALID.equals((Object)cachedEdr.tokenStatus())) {
                log.info("Endpoint data reference found in cache with token status valid, reusing cache record.");
                return CompletableFuture.completedFuture(cachedEdr.endpointDataReference());
            }
            if (this.ongoingNegotiationStorage.isNegotiationOngoing(storageId)) {
                log.info("Negotiation for asset id '{}' on edc: '{}' is already in progress. Returning ongoing negotiation.", (Object)assetId, (Object)dspEndpointAddress);
                return this.ongoingNegotiationStorage.getOngoingNegotiation(storageId);
            }
            if (optionalCatalogItem.isPresent()) {
                catalogItem = optionalCatalogItem.get();
                log.debug("Reusing existing catalogItem: '{}'", (Object)catalogItem);
            } else {
                catalogItem = this.getCatalogItem(dspEndpointAddress, assetId, bpn);
                log.debug("No catalogItem provided, requesting new: '{}'", (Object)catalogItem);
            }
            log.info("No previous or ongoing negotiations for asset id '{}' on edc '{}'. Starting new negotiation.", (Object)assetId, (Object)dspEndpointAddress);
            return this.negotiateEndpointDataReference(dspEndpointAddress, catalogItem, cachedEdr);
        }
    }

    public List<CompletableFuture<EndpointDataReference>> getEndpointDataReferences(String endpointAddress, List<CatalogItem> catalogItems) {
        return catalogItems.stream().map(catalogItem -> {
            try {
                return this.getEndpointDataReference(endpointAddress, (CatalogItem)catalogItem);
            }
            catch (EdcClientException e) {
                String message = "Failed to get EndpointDataReference for endpointAddress '%s', catalogItem = '%s'".formatted(endpointAddress, catalogItem);
                log.warn(message);
                return CompletableFuture.failedFuture(e);
            }
        }).toList();
    }

    private CompletableFuture<EndpointDataReference> negotiateEndpointDataReference(String dspEndpointAddress, CatalogItem catalogItem, EndpointDataReferenceStatus endpointDataReferenceStatus) {
        String assetId = catalogItem.getItemId();
        String storageId = assetId + dspEndpointAddress;
        CompletableFuture<EndpointDataReference> completableFuture = this.awaitEndpointReferenceForAsset(dspEndpointAddress, catalogItem, endpointDataReferenceStatus);
        log.info("Initiated negotiation for id '{}' on edc '{}' and storing it in ongoing negotiations", (Object)assetId, (Object)dspEndpointAddress);
        this.ongoingNegotiationStorage.addToOngoingNegotiations(storageId, completableFuture);
        completableFuture.whenCompleteAsync((endpointDataReference, throwable) -> {
            log.info("Completed waiting for EndpointDataReference. Storing EDR and removing from ongoing negotiations");
            this.endpointDataReferenceCacheService.putEndpointDataReferenceIntoStorage(storageId, (EndpointDataReference)endpointDataReference);
            this.ongoingNegotiationStorage.removeFromOngoingNegotiations(storageId);
        }, (Executor)this.executorService);
        return completableFuture;
    }

    private CompletableFuture<EndpointDataReference> awaitEndpointReferenceForAsset(String dspEndpointAddress, CatalogItem catalogItem, EndpointDataReferenceStatus endpointDataReferenceStatus) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("Get EDC Submodel task for shell descriptor, endpoint " + dspEndpointAddress);
        String bpn = catalogItem.getConnectorId();
        CompletableFuture<String> futureStorageId = CompletableFuture.supplyAsync(() -> {
            try {
                TransferProcessResponse response = this.contractNegotiationService.negotiate(dspEndpointAddress, catalogItem, endpointDataReferenceStatus, bpn);
                return EdcOrchestrator.getStorageId(endpointDataReferenceStatus, response);
            }
            catch (EdcClientException e) {
                throw new CompletionException(e);
            }
        });
        return futureStorageId.thenComposeAsync(storageId -> this.pollingService.createJob().action(() -> this.retrieveEndpointReference((String)storageId, stopWatch)).timeToLive(this.config.getSubmodel().getRequestTtl()).description("waiting for Endpoint Reference retrieval").build().schedule());
    }

    private Optional<EndpointDataReference> retrieveEndpointReference(String storageId, StopWatch stopWatch) {
        log.info("Retrieving dataReference from storage for storageId (assetId or contractAgreementId): {}", (Object)Masker.mask(storageId));
        Optional<EndpointDataReference> dataReference = this.endpointDataReferenceCacheService.getEndpointDataReferenceFromStorage(storageId);
        if (dataReference.isPresent()) {
            EndpointDataReference ref = dataReference.get();
            log.info("Retrieving Endpoint Reference data from EDC data plane with id: {}", (Object)ref.getId());
            EdcOrchestrator.stopWatchOnEdcTask(stopWatch);
            return Optional.of(ref);
        }
        return Optional.empty();
    }

    private static String getStorageId(EndpointDataReferenceStatus endpointDataReferenceStatus, TransferProcessResponse response) {
        String storageId = response != null ? response.getContractId() : endpointDataReferenceStatus.endpointDataReference().getContractId();
        return storageId;
    }
}

