/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.eclipse.tractusx.irs.edc.client.EdcConfiguration;
import org.eclipse.tractusx.irs.edc.client.EdcDataPlaneClient;
import org.eclipse.tractusx.irs.edc.client.EdcOrchestrator;
import org.eclipse.tractusx.irs.edc.client.EdcSubmodelClient;
import org.eclipse.tractusx.irs.edc.client.cache.endpointdatareference.EndpointDataReferenceStatus;
import org.eclipse.tractusx.irs.edc.client.exceptions.EdcClientException;
import org.eclipse.tractusx.irs.edc.client.model.CatalogItem;
import org.eclipse.tractusx.irs.edc.client.model.SubmodelDescriptor;
import org.eclipse.tractusx.irs.edc.client.model.notification.EdcNotification;
import org.eclipse.tractusx.irs.edc.client.model.notification.EdcNotificationResponse;
import org.eclipse.tractusx.irs.edc.client.model.notification.NotificationContent;
import org.eclipse.tractusx.irs.edc.client.util.UriPathJoiner;
import org.eclipse.tractusx.irs.edc.client.util.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class EdcSubmodelClientImpl
implements EdcSubmodelClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdcSubmodelClientImpl.class);
    private static final String DT_DCAT_TYPE_ID = "'http://purl.org/dc/terms/type'.'@id'";
    private static final String DT_TAXONOMY_REGISTRY = "https://w3id.org/catenax/taxonomy#DigitalTwinRegistry";
    private static final String DT_EDC_TYPE = "https://w3id.org/edc/v0.0.1/ns/type";
    private static final String DT_DATA_CORE_REGISTRY = "data.core.digitalTwinRegistry";
    private final EdcConfiguration config;
    private final EdcDataPlaneClient edcDataPlaneClient;
    private final EdcOrchestrator edcOrchestrator;
    private final RetryRegistry retryRegistry;

    private static void stopWatchOnEdcTask(StopWatch stopWatch) {
        stopWatch.stop();
        log.info("EDC Task '{}' took {} ms", (Object)stopWatch.getLastTaskName(), (Object)stopWatch.getLastTaskTimeMillis());
    }

    @Override
    public CompletableFuture<SubmodelDescriptor> getSubmodelPayload(String connectorEndpoint, String submodelDataplaneUrl, String assetId, String bpn) throws EdcClientException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("Get EDC Submodel task for raw payload, endpoint " + connectorEndpoint);
        String dspEndpointAddress = this.appendSuffix(connectorEndpoint, this.config.getControlplane().getProviderSuffix());
        CompletableFuture endpointDataReference = this.execute(dspEndpointAddress, () -> this.edcOrchestrator.getEndpointDataReference(dspEndpointAddress, assetId, bpn, Optional.empty()));
        return this.execute(dspEndpointAddress, () -> endpointDataReference.thenApply(futureEdr -> {
            log.info("Retrieving data from EDC data plane for dataReference with id {}", (Object)futureEdr.getId());
            String payload = this.edcDataPlaneClient.getData((EndpointDataReference)futureEdr, submodelDataplaneUrl);
            EdcSubmodelClientImpl.stopWatchOnEdcTask(stopWatch);
            return new SubmodelDescriptor(futureEdr.getContractId(), payload);
        }));
    }

    @Override
    public CompletableFuture<EdcNotificationResponse> sendNotification(String connectorEndpoint, String assetId, EdcNotification<NotificationContent> notification, String bpn) throws EdcClientException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("Send EDC notification task, endpoint " + connectorEndpoint);
        String dspEndpointAddress = this.appendSuffix(connectorEndpoint, this.config.getControlplane().getProviderSuffix());
        CatalogItem catalogItem = this.execute(dspEndpointAddress, () -> this.edcOrchestrator.getCatalogItem(dspEndpointAddress, assetId, bpn));
        CompletableFuture endpointDataReference = this.execute(dspEndpointAddress, () -> this.edcOrchestrator.getEndpointDataReference(dspEndpointAddress, catalogItem));
        return this.execute(dspEndpointAddress, () -> endpointDataReference.thenApply(futureEdr -> {
            log.info("Sending dataReference to EDC data plane for assetId '{}'", (Object)assetId);
            EdcNotificationResponse response = this.edcDataPlaneClient.sendData((EndpointDataReference)futureEdr, notification);
            EdcSubmodelClientImpl.stopWatchOnEdcTask(stopWatch);
            return response;
        }));
    }

    @Override
    public List<CompletableFuture<EndpointDataReference>> getEndpointReferencesForAsset(String endpointAddress, String filterKey, String filterValue, String bpn) throws EdcClientException {
        return this.getEndpointReferencesForAsset(endpointAddress, filterKey, filterValue, new EndpointDataReferenceStatus(null, EndpointDataReferenceStatus.TokenStatus.REQUIRED_NEW), bpn);
    }

    @Override
    public List<CompletableFuture<EndpointDataReference>> getEndpointReferencesForAsset(String endpointAddress, String filterKey, String filterValue, EndpointDataReferenceStatus endpointDataReferenceStatus, String bpn) throws EdcClientException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("Get EDC Submodel task for shell descriptor, endpoint " + endpointAddress);
        String dspEndpointAddress = this.appendSuffix(endpointAddress, this.config.getControlplane().getProviderSuffix());
        List contractOffers = this.execute(dspEndpointAddress, () -> this.edcOrchestrator.getCatalogItems(dspEndpointAddress, filterKey, filterValue, bpn));
        if (contractOffers.isEmpty()) {
            throw new EdcClientException("Catalog is empty for endpointAddress '%s' filterKey '%s', filterValue '%s'".formatted(endpointAddress, filterKey, filterValue));
        }
        return this.execute(dspEndpointAddress, () -> this.edcOrchestrator.getEndpointDataReferences(dspEndpointAddress, contractOffers));
    }

    @Override
    public List<CompletableFuture<EndpointDataReference>> getEndpointReferencesForRegistryAsset(String endpointAddress, String bpn) throws EdcClientException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("Get EndpointDataReference task for shell descriptor, endpoint " + endpointAddress);
        String dspEndpointAddress = this.appendSuffix(endpointAddress, this.config.getControlplane().getProviderSuffix());
        ArrayList contractOffers = new ArrayList(this.execute(dspEndpointAddress, () -> this.edcOrchestrator.getCatalogItems(dspEndpointAddress, DT_DCAT_TYPE_ID, DT_TAXONOMY_REGISTRY, bpn)));
        if (contractOffers.isEmpty()) {
            log.info("No contract offers found for type 'https://w3id.org/catenax/taxonomy#DigitalTwinRegistry'. Using fallback type 'data.core.digitalTwinRegistry'.");
            List contractOffersDataCore = this.execute(dspEndpointAddress, () -> this.edcOrchestrator.getCatalogItems(dspEndpointAddress, DT_EDC_TYPE, DT_DATA_CORE_REGISTRY, bpn));
            contractOffers.addAll(contractOffersDataCore);
        }
        if (contractOffers.isEmpty()) {
            throw new EdcClientException("No DigitalTwinRegistry contract offers found for endpointAddress '%s' filterKey '%s', filterValue '%s' or filterKey '%s', filterValue '%s'".formatted(endpointAddress, DT_DCAT_TYPE_ID, DT_TAXONOMY_REGISTRY, DT_EDC_TYPE, DT_DATA_CORE_REGISTRY));
        }
        return this.execute(dspEndpointAddress, () -> this.edcOrchestrator.getEndpointDataReferences(dspEndpointAddress, contractOffers));
    }

    private String appendSuffix(String endpointAddress, String providerSuffix) throws EdcClientException {
        String addressWithSuffix;
        if (endpointAddress.endsWith(providerSuffix)) {
            addressWithSuffix = endpointAddress;
        } else {
            try {
                addressWithSuffix = UriPathJoiner.appendPath(endpointAddress, providerSuffix);
            }
            catch (URISyntaxException e) {
                throw new EdcClientException(e);
            }
        }
        return addressWithSuffix;
    }

    private <T> T execute(String endpointAddress, CheckedSupplier<T> supplier) throws EdcClientException {
        if (!UrlValidator.isValidUrl(endpointAddress)) {
            throw new IllegalArgumentException(String.format("Malformed endpoint address '%s'", endpointAddress));
        }
        String host = URI.create(endpointAddress).getHost();
        Retry retry = this.retryRegistry.retry(host, "default");
        try {
            return (T)Retry.decorateCallable((Retry)retry, supplier::get).call();
        }
        catch (EdcClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EdcClientException(e);
        }
    }

    @Generated
    public EdcSubmodelClientImpl(EdcConfiguration config, EdcDataPlaneClient edcDataPlaneClient, EdcOrchestrator edcOrchestrator, RetryRegistry retryRegistry) {
        this.config = config;
        this.edcDataPlaneClient = edcDataPlaneClient;
        this.edcOrchestrator = edcOrchestrator;
        this.retryRegistry = retryRegistry;
    }

    private static interface CheckedSupplier<T> {
        public T get() throws EdcClientException;
    }
}

