/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.eclipse.tractusx.irs.data.CxTestDataContainer;
import org.eclipse.tractusx.irs.data.StringMapper;
import org.eclipse.tractusx.irs.edc.client.EdcSubmodelClient;
import org.eclipse.tractusx.irs.edc.client.cache.endpointdatareference.EndpointDataReferenceStatus;
import org.eclipse.tractusx.irs.edc.client.exceptions.EdcClientException;
import org.eclipse.tractusx.irs.edc.client.model.SubmodelDescriptor;
import org.eclipse.tractusx.irs.edc.client.model.notification.EdcNotification;
import org.eclipse.tractusx.irs.edc.client.model.notification.EdcNotificationResponse;
import org.eclipse.tractusx.irs.edc.client.model.notification.NotificationContent;
import org.eclipse.tractusx.irs.edc.client.relationships.SubmodelTestdataCreator;

public class EdcSubmodelClientLocalStub
implements EdcSubmodelClient {
    public static final String NOT_IMPLEMENTED = "Not implemented";
    private final SubmodelTestdataCreator testdataCreator;

    public EdcSubmodelClientLocalStub(CxTestDataContainer cxTestDataContainer) {
        this.testdataCreator = new SubmodelTestdataCreator(cxTestDataContainer);
    }

    @Override
    public CompletableFuture<SubmodelDescriptor> getSubmodelPayload(String connectorEndpoint, String submodelDataplaneUrl, String assetId, String bpn) throws EdcClientException {
        if ("urn:uuid:c35ee875-5443-4a2d-bc14-fdacd64b9446".equals(assetId)) {
            throw new EdcClientException("Dummy Exception");
        }
        Map<String, Object> submodel = this.testdataCreator.createSubmodelForId(assetId + "_" + submodelDataplaneUrl);
        return CompletableFuture.completedFuture(new SubmodelDescriptor(UUID.randomUUID().toString(), StringMapper.mapToString(submodel)));
    }

    @Override
    public CompletableFuture<EdcNotificationResponse> sendNotification(String submodelEndpointAddress, String assetId, EdcNotification<NotificationContent> notification, String bpn) {
        return CompletableFuture.completedFuture(() -> true);
    }

    @Override
    public List<CompletableFuture<EndpointDataReference>> getEndpointReferencesForAsset(String endpointAddress, String filterKey, String filterValue, EndpointDataReferenceStatus cachedEndpointDataReference, String bpn) throws EdcClientException {
        throw new EdcClientException(NOT_IMPLEMENTED);
    }

    @Override
    public List<CompletableFuture<EndpointDataReference>> getEndpointReferencesForAsset(String endpointAddress, String filterKey, String filterValue, String bpn) throws EdcClientException {
        throw new EdcClientException(NOT_IMPLEMENTED);
    }

    @Override
    public List<CompletableFuture<EndpointDataReference>> getEndpointReferencesForRegistryAsset(String endpointAddress, String bpn) throws EdcClientException {
        throw new EdcClientException(NOT_IMPLEMENTED);
    }
}

