/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client;

import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.eclipse.tractusx.irs.edc.client.EdcConfiguration;
import org.eclipse.tractusx.irs.edc.client.EdcSubmodelClient;
import org.eclipse.tractusx.irs.edc.client.exceptions.EdcClientException;
import org.eclipse.tractusx.irs.edc.client.model.SubmodelDescriptor;
import org.eclipse.tractusx.irs.edc.client.model.notification.EdcNotification;
import org.eclipse.tractusx.irs.edc.client.model.notification.EdcNotificationResponse;
import org.eclipse.tractusx.irs.edc.client.model.notification.NotificationContent;
import org.eclipse.tractusx.irs.edc.client.util.UriPathJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdcSubmodelFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdcSubmodelFacade.class);
    private final EdcSubmodelClient client;
    private final EdcConfiguration config;

    public SubmodelDescriptor getSubmodelPayload(String connectorEndpoint, String submodelDataplaneUrl, String assetId, String bpn) throws EdcClientException {
        try {
            String fullSubmodelDataplaneUrl = this.getFullSubmodelDataplaneUrl(submodelDataplaneUrl);
            log.debug("Requesting Submodel for URL: '{}'", (Object)fullSubmodelDataplaneUrl);
            return this.client.getSubmodelPayload(connectorEndpoint, fullSubmodelDataplaneUrl, assetId, bpn).get(this.config.getAsyncTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.debug("InterruptedException occurred.", (Throwable)e);
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            log.debug("ExecutionException occurred.", (Throwable)e);
            Throwable cause = e.getCause();
            if (cause instanceof EdcClientException) {
                EdcClientException exceptionCause = (EdcClientException)cause;
                throw exceptionCause;
            }
            throw new EdcClientException(cause);
        }
        catch (TimeoutException e) {
            throw new EdcClientException("Timeout while getting submodel payload", e);
        }
    }

    private String getFullSubmodelDataplaneUrl(String submodelDataplaneUrl) throws EdcClientException {
        try {
            return UriPathJoiner.appendPath(submodelDataplaneUrl, this.config.getSubmodel().getSubmodelSuffix());
        }
        catch (URISyntaxException e) {
            throw new EdcClientException("Invalid href URL '%s'".formatted(submodelDataplaneUrl), e);
        }
    }

    public EdcNotificationResponse sendNotification(String submodelEndpointAddress, String assetId, EdcNotification<NotificationContent> notification, String bpn) throws EdcClientException {
        try {
            log.debug("Sending EDC Notification '{}'", notification);
            return this.client.sendNotification(submodelEndpointAddress, assetId, notification, bpn).get(this.config.getAsyncTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EdcClientException) {
                EdcClientException exceptionCause = (EdcClientException)cause;
                throw exceptionCause;
            }
            throw new EdcClientException(cause);
        }
        catch (TimeoutException e) {
            throw new EdcClientException("Timeout while sending notification", e);
        }
    }

    public List<CompletableFuture<EndpointDataReference>> getEndpointReferencesForRegistryAsset(String endpointAddress, String bpn) throws EdcClientException {
        return this.client.getEndpointReferencesForRegistryAsset(endpointAddress, bpn);
    }

    @Generated
    public EdcSubmodelFacade(EdcSubmodelClient client, EdcConfiguration config) {
        this.client = client;
        this.config = config;
    }
}

