/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client;

import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="irsEdcClientEndpointDataReferenceStorage")
public class EndpointDataReferenceStorage {
    private final Map<String, ExpiringContainer> storageMap = new ConcurrentHashMap<String, ExpiringContainer>();
    private final Duration storageDuration;

    public EndpointDataReferenceStorage(@Value(value="${irs-edc-client.controlplane.datareference.storage.duration}") Duration storageDuration) {
        this.storageDuration = storageDuration;
    }

    public void put(String storageId, EndpointDataReference dataReference) {
        this.storageMap.put(storageId, new ExpiringContainer(Instant.now(), dataReference));
        this.cleanup();
    }

    private void cleanup() {
        HashSet<String> keys = new HashSet<String>(this.storageMap.keySet());
        keys.forEach(key -> {
            Instant creationTimestamp = this.storageMap.get(key).getCreationTimestamp();
            if (Instant.now().isAfter(creationTimestamp.plus(this.storageDuration))) {
                this.storageMap.remove(key);
            }
        });
    }

    public Optional<EndpointDataReference> get(String storageId) {
        return Optional.ofNullable(this.storageMap.get(storageId)).map(ExpiringContainer::getDataReference);
    }

    public void clear() {
        this.storageMap.clear();
    }

    private static final class ExpiringContainer {
        private final Instant creationTimestamp;
        private final EndpointDataReference dataReference;

        @Generated
        public ExpiringContainer(Instant creationTimestamp, EndpointDataReference dataReference) {
            this.creationTimestamp = creationTimestamp;
            this.dataReference = dataReference;
        }

        @Generated
        public Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Generated
        public EndpointDataReference getDataReference() {
            return this.dataReference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpiringContainer)) {
                return false;
            }
            ExpiringContainer other = (ExpiringContainer)o;
            Instant this$creationTimestamp = this.getCreationTimestamp();
            Instant other$creationTimestamp = other.getCreationTimestamp();
            if (this$creationTimestamp == null ? other$creationTimestamp != null : !((Object)this$creationTimestamp).equals(other$creationTimestamp)) {
                return false;
            }
            EndpointDataReference this$dataReference = this.getDataReference();
            EndpointDataReference other$dataReference = other.getDataReference();
            return !(this$dataReference == null ? other$dataReference != null : !this$dataReference.equals(other$dataReference));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Instant $creationTimestamp = this.getCreationTimestamp();
            result = result * 59 + ($creationTimestamp == null ? 43 : ((Object)$creationTimestamp).hashCode());
            EndpointDataReference $dataReference = this.getDataReference();
            result = result * 59 + ($dataReference == null ? 43 : $dataReference.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EndpointDataReferenceStorage.ExpiringContainer(creationTimestamp=" + String.valueOf(this.getCreationTimestamp()) + ", dataReference=" + String.valueOf(this.getDataReference()) + ")";
        }
    }
}

