/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.springframework.stereotype.Service;

@Service
public class OngoingNegotiationStorage {
    private final ConcurrentMap<String, CompletableFuture<EndpointDataReference>> ongoingNegotiations = new ConcurrentHashMap<String, CompletableFuture<EndpointDataReference>>();

    public void addToOngoingNegotiations(String assetId, CompletableFuture<EndpointDataReference> completableFuture) {
        this.ongoingNegotiations.put(assetId, completableFuture);
    }

    public void removeFromOngoingNegotiations(String assetId) {
        this.ongoingNegotiations.remove(assetId);
    }

    public CompletableFuture<EndpointDataReference> getOngoingNegotiation(String assetId) {
        return (CompletableFuture)this.ongoingNegotiations.get(assetId);
    }

    public boolean isNegotiationOngoing(String assetId) {
        return this.ongoingNegotiations.containsKey(assetId);
    }

    public Set<String> getOngoingNegotiations() {
        return this.ongoingNegotiations.keySet();
    }

    @Generated
    public OngoingNegotiationStorage() {
    }
}

