/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client;

import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.tractusx.irs.edc.client.RunnableDecorator;

public class PollingJob<T> {
    private final Clock clock;
    private final ScheduledExecutorService scheduler;
    private Duration timeToLive;
    private Supplier<Optional<T>> action;
    private String description;
    private Duration pollInterval;

    public CompletableFuture<T> schedule() {
        this.enforceRequiredParameters();
        CompletableFuture completableFuture = new CompletableFuture();
        Runnable actionToUse = () -> this.action.get().ifPresent(completableFuture::complete);
        Runnable actionWithTimeoutAndErrorHandling = this.wrapWithErrorHandler(this.wrapWithTimeout(actionToUse), completableFuture);
        ScheduledFuture<?> scheduledFuture = this.scheduler.scheduleWithFixedDelay(actionWithTimeoutAndErrorHandling, 0L, this.pollInterval.toMillis(), TimeUnit.MILLISECONDS);
        completableFuture.whenComplete((result, thrown) -> scheduledFuture.cancel(true));
        return completableFuture;
    }

    private Runnable wrapWithErrorHandler(Runnable action, CompletableFuture<T> completableFuture) {
        return RunnableDecorator.withErrorHandler(action, completableFuture::completeExceptionally);
    }

    private void enforceRequiredParameters() {
        Objects.requireNonNull(this.action, "An action must be supplied to the polling job.");
        Objects.requireNonNull(this.clock, "A clock must be supplied to the polling job.");
        Objects.requireNonNull(this.scheduler, "A scheduler must be supplied to the polling job.");
        this.pollInterval = Objects.requireNonNullElse(this.pollInterval, Duration.ofSeconds(1L));
    }

    private Runnable wrapWithTimeout(Runnable actionToUse) {
        if (this.timeToLive != null) {
            return RunnableDecorator.withTimeout(actionToUse, this.timeToLive, this.clock, StringUtils.trimToEmpty((String)this.description));
        }
        return actionToUse;
    }

    @Generated
    PollingJob(Clock clock, ScheduledExecutorService scheduler, Duration timeToLive, Supplier<Optional<T>> action, String description, Duration pollInterval) {
        this.clock = clock;
        this.scheduler = scheduler;
        this.timeToLive = timeToLive;
        this.action = action;
        this.description = description;
        this.pollInterval = pollInterval;
    }

    @Generated
    public static <T> PollingJobBuilder<T> builder() {
        return new PollingJobBuilder();
    }

    @Generated
    public static class PollingJobBuilder<T> {
        @Generated
        private Clock clock;
        @Generated
        private ScheduledExecutorService scheduler;
        @Generated
        private Duration timeToLive;
        @Generated
        private Supplier<Optional<T>> action;
        @Generated
        private String description;
        @Generated
        private Duration pollInterval;

        @Generated
        PollingJobBuilder() {
        }

        @Generated
        public PollingJobBuilder<T> clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        @Generated
        public PollingJobBuilder<T> scheduler(ScheduledExecutorService scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        @Generated
        public PollingJobBuilder<T> timeToLive(Duration timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        @Generated
        public PollingJobBuilder<T> action(Supplier<Optional<T>> action) {
            this.action = action;
            return this;
        }

        @Generated
        public PollingJobBuilder<T> description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public PollingJobBuilder<T> pollInterval(Duration pollInterval) {
            this.pollInterval = pollInterval;
            return this;
        }

        @Generated
        public PollingJob<T> build() {
            return new PollingJob<T>(this.clock, this.scheduler, this.timeToLive, this.action, this.description, this.pollInterval);
        }

        @Generated
        public String toString() {
            return "PollingJob.PollingJobBuilder(clock=" + String.valueOf(this.clock) + ", scheduler=" + String.valueOf(this.scheduler) + ", timeToLive=" + String.valueOf(this.timeToLive) + ", action=" + String.valueOf(this.action) + ", description=" + this.description + ", pollInterval=" + String.valueOf(this.pollInterval) + ")";
        }
    }
}

