/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client;

import java.time.Clock;
import java.time.Duration;
import java.time.LocalTime;
import java.util.function.Consumer;
import lombok.Generated;
import org.eclipse.tractusx.irs.edc.client.exceptions.TimeoutException;

public class RunnableDecorator {
    public static Runnable withTimeout(Runnable action, Duration ttl, Clock clock, String timeoutMessage) {
        LocalTime startTime = LocalTime.now(clock);
        return () -> {
            LocalTime now = LocalTime.now(clock);
            if (startTime.plus(ttl).isBefore(now)) {
                throw new TimeoutException("'" + timeoutMessage + "' timed out after " + String.valueOf(ttl));
            }
            action.run();
        };
    }

    public static Runnable withErrorHandler(Runnable action, Consumer<Exception> onError) {
        return () -> {
            try {
                action.run();
            }
            catch (Exception e) {
                onError.accept(e);
            }
        };
    }

    @Generated
    private RunnableDecorator() {
    }
}

