/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.asset;

import jakarta.json.JsonObject;
import java.lang.invoke.CallSite;
import java.util.Map;
import lombok.Generated;
import org.eclipse.edc.spi.types.domain.DataAddress;
import org.eclipse.edc.spi.types.domain.asset.Asset;
import org.eclipse.tractusx.irs.edc.client.EdcConfiguration;
import org.eclipse.tractusx.irs.edc.client.asset.model.Asset;
import org.eclipse.tractusx.irs.edc.client.asset.model.Notification;
import org.eclipse.tractusx.irs.edc.client.asset.model.NotificationMethod;
import org.eclipse.tractusx.irs.edc.client.asset.model.NotificationType;
import org.eclipse.tractusx.irs.edc.client.asset.model.exception.CreateEdcAssetException;
import org.eclipse.tractusx.irs.edc.client.asset.model.exception.DeleteEdcAssetException;
import org.eclipse.tractusx.irs.edc.client.asset.model.exception.EdcAssetAlreadyExistsException;
import org.eclipse.tractusx.irs.edc.client.asset.model.exception.GetEdcAssetException;
import org.eclipse.tractusx.irs.edc.client.asset.model.exception.UpdateEdcAssetException;
import org.eclipse.tractusx.irs.edc.client.model.EdcTechnicalServiceAuthentication;
import org.eclipse.tractusx.irs.edc.client.transformer.EdcTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class EdcAssetService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdcAssetService.class);
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    private static final String DEFAULT_POLICY_ID = "use-eu";
    private static final String DEFAULT_METHOD = "POST";
    private static final String ASSET_DATA_ADDRESS_BASE_URL = "https://w3id.org/edc/v0.0.1/ns/baseUrl";
    private static final String ASSET_DATA_ADDRESS_PROXY_METHOD = "https://w3id.org/edc/v0.0.1/ns/proxyMethod";
    private static final String ASSET_DATA_ADDRESS_PROXY_BODY = "https://w3id.org/edc/v0.0.1/ns/proxyBody";
    private static final String ASSET_DATA_ADDRESS_PROXY_PATH = "https://w3id.org/edc/v0.0.1/ns/proxyPath";
    private static final String ASSET_DATA_ADDRESS_PROXY_QUERY_PARAMS = "https://w3id.org/edc/v0.0.1/ns/proxyQueryParams";
    private static final String ASSET_DATA_ADDRESS_TECHNICAL_SERVICE_API_KEY = "header:x-technical-service-key";
    private static final String ASSET_DATA_ADDRESS_METHOD = "https://w3id.org/edc/v0.0.1/ns/method";
    private static final String ASSET_PROPERTY_DESCRIPTION = "https://w3id.org/edc/v0.0.1/ns/description";
    private static final String ASSET_PROPERTY_CONTENT_TYPE = "https://w3id.org/edc/v0.0.1/ns/contenttype";
    private static final String ASSET_PROPERTY_POLICY_ID = "https://w3id.org/edc/v0.0.1/ns/policy-id";
    private static final String ASSET_PROPERTY_EDC_TYPE = "https://w3id.org/edc/v0.0.1/ns/type";
    private static final String ASSET_PROPERTY_DCAT_TYPE = "http://purl.org/dc/terms/type";
    private static final String ASSET_PROPERTY_DATA_CORE_REGISTRY = "data.core.digitalTwinRegistry";
    private static final String ASSET_PROPERTY_DCAT_REGISTRY = "https://w3id.org/catenax/taxonomy#DigitalTwinRegistry";
    private static final String ASSET_PROPERTY_REGISTRY_VERSION = "3.0";
    private static final String ASSET_PROPERTY_COMMON_VERSION_KEY = "https://w3id.org/catenax/ontology/common#version";
    private static final String ASSET_PROPERTY_NOTIFICATION_VERSION = "1.2";
    public static final String DATA_ADDRESS_TYPE_HTTP_DATA = "HttpData";
    private final EdcTransformer edcTransformer;
    private final EdcConfiguration config;
    private final RestTemplate restTemplate;

    public String createNotificationAsset(String baseUrl, String assetName, NotificationMethod notificationMethod, NotificationType notificationType, EdcTechnicalServiceAuthentication edcTechnicalServiceAuthentication) throws CreateEdcAssetException {
        Notification notification = Notification.toNotification(notificationMethod, notificationType);
        org.eclipse.edc.spi.types.domain.asset.Asset request = this.createNotificationAssetRequest(assetName, baseUrl, notification, edcTechnicalServiceAuthentication);
        return this.sendRequest(request);
    }

    public String createNotificationAsset(String baseUrl, String assetName, Notification notification) throws CreateEdcAssetException {
        org.eclipse.edc.spi.types.domain.asset.Asset request = this.createNotificationAssetRequest(assetName, baseUrl, notification, null);
        return this.sendRequest(request);
    }

    public String createDtrAsset(String baseUrl, String assetId) throws CreateEdcAssetException {
        org.eclipse.edc.spi.types.domain.asset.Asset request = this.createDtrAssetRequest(assetId, baseUrl);
        return this.sendRequest(request);
    }

    public String createSubmodelAsset(String baseUrl, String assetId) throws CreateEdcAssetException {
        org.eclipse.edc.spi.types.domain.asset.Asset request = this.createSubmodelAssetRequest(assetId, baseUrl);
        return this.sendRequest(request);
    }

    private String sendRequest(org.eclipse.edc.spi.types.domain.asset.Asset request) throws CreateEdcAssetException {
        JsonObject transformedPayload = this.edcTransformer.transformAssetToJson(request);
        try {
            ResponseEntity createEdcDataAssetResponse = this.restTemplate.postForEntity(this.config.getControlplane().getEndpoint().getAsset(), (Object)transformedPayload.toString(), String.class, new Object[0]);
            HttpStatusCode responseCode = createEdcDataAssetResponse.getStatusCode();
            if (responseCode.value() == HttpStatus.OK.value()) {
                return request.getId();
            }
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().value() == HttpStatus.CONFLICT.value()) {
                throw new EdcAssetAlreadyExistsException("asset already exists in the EDC", e);
            }
            throw new CreateEdcAssetException(e);
        }
        throw new CreateEdcAssetException("Failed to create asset %s".formatted(request.getId()));
    }

    public void deleteAsset(String assetId) throws DeleteEdcAssetException {
        String deleteUri = UriComponentsBuilder.fromPath((String)this.config.getControlplane().getEndpoint().getAsset()).pathSegment(new String[]{"{notificationAssetId}"}).buildAndExpand(new Object[]{assetId}).toUriString();
        try {
            this.restTemplate.delete(deleteUri, new Object[0]);
        }
        catch (RestClientException e) {
            log.error("Failed to delete EDC notification asset {}. Reason: ", (Object)assetId, (Object)e);
            throw new DeleteEdcAssetException(e);
        }
    }

    public ResponseEntity<Asset> getAsset(String assetId) throws GetEdcAssetException {
        String updateUri = UriComponentsBuilder.fromPath((String)this.config.getControlplane().getEndpoint().getAsset()).pathSegment(new String[]{"{assetId}"}).buildAndExpand(new Object[]{assetId}).toUriString();
        try {
            return this.restTemplate.getForEntity(updateUri, Asset.class, new Object[0]);
        }
        catch (RestClientException e) {
            log.error("Failed to get EDC asset {}. Reason: ", (Object)assetId, (Object)e);
            throw new GetEdcAssetException(e);
        }
    }

    public void updateAsset(Asset assetUpdateRequest) throws UpdateEdcAssetException {
        String updateUri = UriComponentsBuilder.fromPath((String)this.config.getControlplane().getEndpoint().getAsset()).toUriString();
        try {
            this.restTemplate.put(updateUri, (Object)assetUpdateRequest, new Object[0]);
        }
        catch (RestClientException e) {
            log.error("Failed to update EDC notification asset's data address {}. Reason: ", (Object)assetUpdateRequest.getAssetId(), (Object)e);
            throw new UpdateEdcAssetException(e);
        }
    }

    private org.eclipse.edc.spi.types.domain.asset.Asset createNotificationAssetRequest(String assetName, String baseUrl, Notification notification, EdcTechnicalServiceAuthentication edcTechnicalServiceAuthentication) {
        Map<String, Map<String, CallSite>> properties = Map.of(ASSET_PROPERTY_DESCRIPTION, assetName, ASSET_PROPERTY_CONTENT_TYPE, DEFAULT_CONTENT_TYPE, ASSET_PROPERTY_POLICY_ID, DEFAULT_POLICY_ID, ASSET_PROPERTY_COMMON_VERSION_KEY, ASSET_PROPERTY_NOTIFICATION_VERSION, ASSET_PROPERTY_DCAT_TYPE, Map.of("@id", "https://w3id.org/catenax/taxonomy#" + notification.getValue()));
        DataAddress.Builder dataAddressBuilder = DataAddress.Builder.newInstance().type(DATA_ADDRESS_TYPE_HTTP_DATA).property(ASSET_PROPERTY_EDC_TYPE, (Object)DATA_ADDRESS_TYPE_HTTP_DATA).property(ASSET_DATA_ADDRESS_BASE_URL, (Object)baseUrl).property(ASSET_DATA_ADDRESS_PROXY_METHOD, (Object)Boolean.TRUE.toString()).property(ASSET_DATA_ADDRESS_PROXY_BODY, (Object)Boolean.TRUE.toString()).property(ASSET_DATA_ADDRESS_METHOD, (Object)DEFAULT_METHOD);
        EdcAssetService.enrichOptionalEdcApiAuthenticationToDataAddress(edcTechnicalServiceAuthentication, dataAddressBuilder);
        DataAddress dataAddress = dataAddressBuilder.build();
        return Asset.Builder.newInstance().id(notification.getAssetId()).contentType("Asset").properties(properties).dataAddress(dataAddress).build();
    }

    private org.eclipse.edc.spi.types.domain.asset.Asset createDtrAssetRequest(String assetId, String baseUrl) {
        Map<String, Map<String, String>> properties = Map.of(ASSET_PROPERTY_DESCRIPTION, "Digital Twin Registry Asset", ASSET_PROPERTY_EDC_TYPE, ASSET_PROPERTY_DATA_CORE_REGISTRY, ASSET_PROPERTY_COMMON_VERSION_KEY, ASSET_PROPERTY_REGISTRY_VERSION, ASSET_PROPERTY_DCAT_TYPE, Map.of("@id", ASSET_PROPERTY_DCAT_REGISTRY));
        DataAddress dataAddress = DataAddress.Builder.newInstance().type("DataAddress").property(ASSET_PROPERTY_EDC_TYPE, (Object)DATA_ADDRESS_TYPE_HTTP_DATA).property(ASSET_DATA_ADDRESS_BASE_URL, (Object)baseUrl).property(ASSET_DATA_ADDRESS_PROXY_METHOD, (Object)Boolean.TRUE.toString()).property(ASSET_DATA_ADDRESS_PROXY_BODY, (Object)Boolean.TRUE.toString()).property(ASSET_DATA_ADDRESS_PROXY_PATH, (Object)Boolean.TRUE.toString()).property(ASSET_DATA_ADDRESS_PROXY_QUERY_PARAMS, (Object)Boolean.TRUE.toString()).build();
        return Asset.Builder.newInstance().id(assetId).contentType("Asset").properties(properties).dataAddress(dataAddress).build();
    }

    private org.eclipse.edc.spi.types.domain.asset.Asset createSubmodelAssetRequest(String assetId, String baseUrl) {
        Map<String, String> properties = Map.of(ASSET_PROPERTY_DESCRIPTION, "Submodel Server Asset");
        DataAddress dataAddress = DataAddress.Builder.newInstance().type("DataAddress").property(ASSET_PROPERTY_EDC_TYPE, (Object)DATA_ADDRESS_TYPE_HTTP_DATA).property(ASSET_DATA_ADDRESS_BASE_URL, (Object)baseUrl).property(ASSET_DATA_ADDRESS_PROXY_METHOD, (Object)Boolean.FALSE.toString()).property(ASSET_DATA_ADDRESS_PROXY_BODY, (Object)Boolean.FALSE.toString()).property(ASSET_DATA_ADDRESS_PROXY_PATH, (Object)Boolean.TRUE.toString()).property(ASSET_DATA_ADDRESS_PROXY_QUERY_PARAMS, (Object)Boolean.FALSE.toString()).build();
        return Asset.Builder.newInstance().id(assetId).contentType("Asset").properties(properties).dataAddress(dataAddress).build();
    }

    private static void enrichOptionalEdcApiAuthenticationToDataAddress(EdcTechnicalServiceAuthentication edcTechnicalServiceAuthentication, DataAddress.Builder dataAddressBuilder) {
        if (edcTechnicalServiceAuthentication != null && edcTechnicalServiceAuthentication.getTechnicalServiceApiKey() != null && !edcTechnicalServiceAuthentication.getTechnicalServiceApiKey().isEmpty()) {
            dataAddressBuilder.property(ASSET_DATA_ADDRESS_TECHNICAL_SERVICE_API_KEY, (Object)edcTechnicalServiceAuthentication.getTechnicalServiceApiKey());
        }
    }

    @Generated
    public EdcAssetService(EdcTransformer edcTransformer, EdcConfiguration config, RestTemplate restTemplate) {
        this.edcTransformer = edcTransformer;
        this.config = config;
        this.restTemplate = restTemplate;
    }
}

