/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.asset.model;

import lombok.Generated;
import org.eclipse.tractusx.irs.edc.client.asset.model.NotificationMethod;
import org.eclipse.tractusx.irs.edc.client.asset.model.NotificationType;

public enum Notification {
    RECEIVE_QUALITY_INVESTIGATION_NOTIFICATION("ReceiveQualityInvestigationNotification", "qualityinvestigationnotification-receive"),
    RECEIVE_QUALITY_ALERT_NOTIFICATION("ReceiveQualityAlertNotification", "qualityalertnotification-receipt"),
    UPDATE_QUALITY_INVESTIGATION_NOTIFICATION("UpdateQualityInvestigationNotification", "qualityinvestigationnotification-update"),
    UPDATE_QUALITY_ALERT_NOTIFICATION("UpdateQualityAlertNotification", "qualityalertnotification-update"),
    RESOLVE_QUALITY_INVESTIGATION_NOTIFICATION("ResolveQualityInvestigationNotification", "qualityinvestigationnotification-resolve"),
    RESOLVE_QUALITY_ALERT_NOTIFICATION("ResolveQualityAlertNotification", "qualityalertnotification-resolve");

    private final String value;
    private final String assetId;

    private Notification(String value, String assetId) {
        this.value = value;
        this.assetId = assetId;
    }

    public static Notification toNotification(NotificationMethod notificationMethod, NotificationType notificationType) {
        return switch (notificationType) {
            default -> throw new IncompatibleClassChangeError();
            case NotificationType.QUALITY_ALERT -> {
                switch (notificationMethod) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case RECEIVE: {
                        yield RECEIVE_QUALITY_ALERT_NOTIFICATION;
                    }
                    case UPDATE: {
                        yield UPDATE_QUALITY_ALERT_NOTIFICATION;
                    }
                    case RESOLVE: 
                }
                yield RESOLVE_QUALITY_ALERT_NOTIFICATION;
            }
            case NotificationType.QUALITY_INVESTIGATION -> {
                switch (notificationMethod) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case RECEIVE: {
                        yield RECEIVE_QUALITY_INVESTIGATION_NOTIFICATION;
                    }
                    case UPDATE: {
                        yield UPDATE_QUALITY_INVESTIGATION_NOTIFICATION;
                    }
                    case RESOLVE: 
                }
                yield RESOLVE_QUALITY_INVESTIGATION_NOTIFICATION;
            }
        };
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getAssetId() {
        return this.assetId;
    }
}

