/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.cache.endpointdatareference;

import java.time.Instant;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.edc.spi.types.domain.edr.EndpointDataReference;
import org.eclipse.tractusx.irs.edc.client.EndpointDataReferenceStorage;
import org.eclipse.tractusx.irs.edc.client.cache.endpointdatareference.EndpointDataReferenceStatus;
import org.eclipse.tractusx.irs.edc.client.model.EDRAuthCode;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EndpointDataReferenceCacheService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EndpointDataReferenceCacheService.class);
    private final EndpointDataReferenceStorage endpointDataReferenceStorage;

    public EndpointDataReferenceStatus getEndpointDataReference(String assetId) {
        String authCode;
        log.info("Retrieving dataReference from storage for assetId {}", (Object)assetId);
        Optional<EndpointDataReference> endpointDataReferenceOptional = this.endpointDataReferenceStorage.get(assetId);
        if (endpointDataReferenceOptional.isPresent() && (authCode = endpointDataReferenceOptional.get().getAuthCode()) != null) {
            EndpointDataReference endpointDataReference = endpointDataReferenceOptional.get();
            if (EndpointDataReferenceCacheService.isTokenExpired(authCode)) {
                log.info("Endpoint data reference with expired token and id: {} for assetId: {} found in storage.", (Object)endpointDataReference.getId(), (Object)assetId);
                return new EndpointDataReferenceStatus(endpointDataReference, EndpointDataReferenceStatus.TokenStatus.EXPIRED);
            }
            log.info("Endpoint data reference with id: {} for assetId: {} found in storage.", (Object)endpointDataReference.getId(), (Object)assetId);
            return new EndpointDataReferenceStatus(endpointDataReference, EndpointDataReferenceStatus.TokenStatus.VALID);
        }
        log.info("Endpoint data reference for asset id: {} not found in storage.", (Object)assetId);
        return new EndpointDataReferenceStatus(null, EndpointDataReferenceStatus.TokenStatus.REQUIRED_NEW);
    }

    public Optional<EndpointDataReference> getEndpointDataReferenceFromStorage(String storageId) {
        return this.endpointDataReferenceStorage.get(storageId);
    }

    public void putEndpointDataReferenceIntoStorage(String assetId, EndpointDataReference endpointDataReference) {
        this.endpointDataReferenceStorage.put(assetId, endpointDataReference);
    }

    private static boolean isTokenExpired(@NotNull String authCode) {
        Instant tokenExpirationInstant = EndpointDataReferenceCacheService.extractTokenExpiration(authCode);
        return Instant.now().isAfter(tokenExpirationInstant);
    }

    private static Instant extractTokenExpiration(String token) {
        return Instant.ofEpochSecond(EDRAuthCode.fromAuthCodeToken(token).getExp());
    }

    @Generated
    public EndpointDataReferenceCacheService(EndpointDataReferenceStorage endpointDataReferenceStorage) {
        this.endpointDataReferenceStorage = endpointDataReferenceStorage;
    }
}

