/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.configuration;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsonp.JSONPModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.eclipse.edc.jsonld.TitaniumJsonLd;
import org.eclipse.edc.policy.model.AtomicConstraint;
import org.eclipse.edc.policy.model.LiteralExpression;
import org.eclipse.edc.spi.monitor.ConsoleMonitor;
import org.eclipse.edc.spi.monitor.Monitor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="irsEdcClientJsonLdConfiguration")
public class JsonLdConfiguration {
    public static final String NAMESPACE_ODRL = "http://www.w3.org/ns/odrl/2/";
    public static final String NAMESPACE_DSPACE = "https://w3id.org/dspace/v0.8/";
    public static final String NAMESPACE_DCAT = "https://www.w3.org/ns/dcat/";
    public static final String NAMESPACE_EDC = "https://w3id.org/edc/v0.0.1/ns/";
    public static final String NAMESPACE_EDC_CID = "https://w3id.org/edc/v0.0.1/ns/cid";
    public static final String NAMESPACE_EDC_PARTICIPANT_ID = "https://w3id.org/edc/v0.0.1/ns/participantId";
    public static final String NAMESPACE_EDC_ID = "https://w3id.org/edc/v0.0.1/ns/id";
    public static final String NAMESPACE_TRACTUSX = "https://w3id.org/tractusx/v0.0.1/ns/";
    public static final String NAMESPACE_DCT = "http://purl.org/dc/terms/";
    public static final String JSON_LD_OBJECT_MAPPER = "jsonLdObjectMapper";
    public static final String NAMESPACE_CATENAX_POLICY = "https://w3id.org/catenax/policy/";
    public static final String NAMESPACE_CX_TAXONOMY = "https://w3id.org/catenax/taxonomy#";
    public static final String NAMESPACE_CX_ONTOLOGY = "https://w3id.org/catenax/ontology/common#";

    @Bean
    TitaniumJsonLd titaniumJsonLd(Monitor monitor) {
        TitaniumJsonLd titaniumJsonLd = new TitaniumJsonLd(monitor);
        titaniumJsonLd.registerNamespace("odrl", NAMESPACE_ODRL);
        titaniumJsonLd.registerNamespace("dct", NAMESPACE_DCT);
        titaniumJsonLd.registerNamespace("tx", NAMESPACE_TRACTUSX);
        titaniumJsonLd.registerNamespace("edc", NAMESPACE_EDC);
        titaniumJsonLd.registerNamespace("dcat", NAMESPACE_DCAT);
        titaniumJsonLd.registerNamespace("dspace", NAMESPACE_DSPACE);
        titaniumJsonLd.registerNamespace("cx-policy", NAMESPACE_CATENAX_POLICY);
        return titaniumJsonLd;
    }

    @Bean
    Monitor monitor() {
        return new ConsoleMonitor();
    }

    @Bean(value={"jsonLdObjectMapper"})
    ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.registerModule((Module)new JSONPModule());
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.registerSubtypes(new Class[]{AtomicConstraint.class, LiteralExpression.class});
        return objectMapper;
    }
}

