/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.contract.service;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.tractusx.irs.edc.client.EdcConfiguration;
import org.eclipse.tractusx.irs.edc.client.contract.model.EdcContractAgreementNegotiationResponse;
import org.eclipse.tractusx.irs.edc.client.contract.model.EdcContractAgreementRequest;
import org.eclipse.tractusx.irs.edc.client.contract.model.EdcContractAgreementsResponse;
import org.eclipse.tractusx.irs.edc.client.contract.model.exception.ContractAgreementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service(value="irsEdcClientEdcContractAgreementService")
public class EdcContractAgreementService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdcContractAgreementService.class);
    public static final String EDC_REQUEST_SUFFIX = "/request";
    public static final String EDC_CONTRACT_AGREEMENT_ID = "id";
    private final EdcConfiguration config;
    private final RestTemplate edcRestTemplate;

    public EdcContractAgreementService(EdcConfiguration config, @Qualifier(value="edcClientRestTemplate") RestTemplate edcRestTemplate) {
        this.config = config;
        this.edcRestTemplate = edcRestTemplate;
    }

    public List<EdcContractAgreementsResponse> getContractAgreements(List<String> contractAgreementIds) throws ContractAgreementException {
        EdcContractAgreementRequest edcContractAgreementRequest = this.buildContractAgreementRequest(contractAgreementIds);
        EdcConfiguration.ControlplaneConfig.EndpointConfig endpoint = this.config.getControlplane().getEndpoint();
        String contractAgreements = endpoint.getContractAgreements();
        ResponseEntity edcContractAgreementListResponseEntity = this.edcRestTemplate.exchange(endpoint.getData() + contractAgreements + EDC_REQUEST_SUFFIX, HttpMethod.POST, new HttpEntity((Object)edcContractAgreementRequest, (MultiValueMap)this.headers()), EdcContractAgreementsResponse[].class, new Object[0]);
        Object[] contractAgreementListWrapper = (EdcContractAgreementsResponse[])edcContractAgreementListResponseEntity.getBody();
        if (ArrayUtils.isNotEmpty((Object[])contractAgreementListWrapper)) {
            return List.of(contractAgreementListWrapper);
        }
        throw new ContractAgreementException("Empty message body on edc response: " + String.valueOf(edcContractAgreementListResponseEntity));
    }

    public EdcContractAgreementNegotiationResponse getContractAgreementNegotiation(String contractAgreementId) {
        EdcConfiguration.ControlplaneConfig.EndpointConfig endpoint = this.config.getControlplane().getEndpoint();
        String contractAgreements = endpoint.getContractAgreements();
        ResponseEntity contractNegotiationResponseEntity = this.edcRestTemplate.exchange(endpoint.getData() + contractAgreements + "/" + contractAgreementId + "/negotiation", HttpMethod.GET, new HttpEntity((MultiValueMap)this.headers()), EdcContractAgreementNegotiationResponse.class, new Object[0]);
        return (EdcContractAgreementNegotiationResponse)contractNegotiationResponseEntity.getBody();
    }

    private EdcContractAgreementRequest buildContractAgreementRequest(List<String> contractAgreementIds) {
        EdcContractAgreementRequest.EdcContractAgreementFilterExpression edcContractAgreementFilterExpression = new EdcContractAgreementRequest.EdcContractAgreementFilterExpression(EDC_CONTRACT_AGREEMENT_ID, "in", contractAgreementIds);
        return new EdcContractAgreementRequest(edcContractAgreementFilterExpression);
    }

    private HttpHeaders headers() {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        headers.setContentType(MediaType.APPLICATION_JSON);
        String apiKeyHeader = this.config.getControlplane().getApiKey().getHeader();
        if (apiKeyHeader != null) {
            headers.add(apiKeyHeader, this.config.getControlplane().getApiKey().getSecret());
        }
        return headers;
    }
}

