/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.contract.service;

import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.eclipse.tractusx.irs.edc.client.EdcConfiguration;
import org.eclipse.tractusx.irs.edc.client.asset.model.EdcContext;
import org.eclipse.tractusx.irs.edc.client.contract.model.EdcContractDefinition;
import org.eclipse.tractusx.irs.edc.client.contract.model.EdcContractDefinitionCriteria;
import org.eclipse.tractusx.irs.edc.client.contract.model.EdcContractDefinitionQuerySpec;
import org.eclipse.tractusx.irs.edc.client.contract.model.exception.CreateEdcContractDefinitionException;
import org.eclipse.tractusx.irs.edc.client.contract.model.exception.EdcContractDefinitionAlreadyExists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class EdcContractDefinitionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdcContractDefinitionService.class);
    private static final String ASSET_SELECTOR_ID = "https://w3id.org/edc/v0.0.1/ns/id";
    private static final String ASSET_SELECTOR_EQUALITY_OPERATOR = "=";
    private static final String ASSET_SELECTOR_TYPE = "CriterionDto";
    private static final String CONTRACT_DEFINITION_TYPE = "ContractDefinition";
    private final EdcConfiguration config;
    private final RestTemplate restTemplate;

    public String createContractDefinition(String assetId, String policyId) throws CreateEdcContractDefinitionException {
        String contractId = UUID.randomUUID().toString();
        EdcContractDefinition createContractDefinitionRequest = this.createContractDefinitionRequest(assetId, policyId, contractId);
        try {
            ResponseEntity createContractDefinitionResponse = this.restTemplate.postForEntity(this.config.getControlplane().getEndpoint().getContractDefinition(), (Object)createContractDefinitionRequest, String.class, new Object[0]);
            HttpStatusCode responseCode = createContractDefinitionResponse.getStatusCode();
            if (responseCode.value() == HttpStatus.OK.value()) {
                return policyId;
            }
            throw new CreateEdcContractDefinitionException("Failed to create EDC contract definition for %s asset id".formatted(assetId));
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().value() == HttpStatus.CONFLICT.value()) {
                throw new EdcContractDefinitionAlreadyExists("Contract definition already exists in the EDC", e);
            }
            log.error("Failed to create edc contract definition for {} notification asset and {} policy definition id. Reason: ", new Object[]{assetId, policyId, e});
            throw new CreateEdcContractDefinitionException(e);
        }
    }

    public EdcContractDefinition createContractDefinitionRequest(String assetId, String accessPolicyId, String contractId) {
        EdcContractDefinitionCriteria edcContractDefinitionCriteria = EdcContractDefinitionCriteria.builder().type(ASSET_SELECTOR_TYPE).operandLeft(ASSET_SELECTOR_ID).operandRight(assetId).operator(ASSET_SELECTOR_EQUALITY_OPERATOR).build();
        EdcContext edcContext = EdcContext.builder().edc("https://w3id.org/edc/v0.0.1/ns/").build();
        return EdcContractDefinition.builder().contractPolicyId(accessPolicyId).edcContext(edcContext).type(CONTRACT_DEFINITION_TYPE).accessPolicyId(accessPolicyId).contractDefinitionId(contractId).assetsSelector(edcContractDefinitionCriteria).build();
    }

    public ResponseEntity<List<EdcContractDefinition>> getContractDefinitions(EdcContractDefinitionQuerySpec edcContractDefinitionQuerySpec) {
        return this.restTemplate.exchange(this.config.getControlplane().getEndpoint().getContractDefinition() + "/request", HttpMethod.POST, new HttpEntity((Object)edcContractDefinitionQuerySpec), (ParameterizedTypeReference)new ParameterizedTypeReference<List<EdcContractDefinition>>(){}, new Object[0]);
    }

    public void deleteContractDefinition(String contractDefinitionId) {
        this.restTemplate.delete(this.config.getControlplane().getEndpoint().getContractDefinition() + "/{contractDefinitionId}", new Object[]{contractDefinitionId});
    }

    @Generated
    public EdcContractDefinitionService(EdcConfiguration config, RestTemplate restTemplate) {
        this.config = config;
        this.restTemplate = restTemplate;
    }
}

