/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.eclipse.edc.policy.model.Duty;
import org.eclipse.edc.policy.model.Permission;
import org.eclipse.edc.policy.model.Policy;
import org.eclipse.edc.policy.model.Prohibition;

@JsonDeserialize(builder=ContractOfferBuilder.class)
public final class ContractOffer {
    public static final String ID_PROPERTY = "@id";
    public static final String TYPE_PROPERTY = "@type";
    public static final String ODRL_NAMESPACE = "http://www.w3.org/ns/odrl/2/";
    public static final String ODRL_PERMISSION_ATTRIBUTE = "http://www.w3.org/ns/odrl/2/permission";
    public static final String ODRL_PROHIBITION_ATTRIBUTE = "http://www.w3.org/ns/odrl/2/prohibition";
    public static final String ODRL_OBLIGATION_ATTRIBUTE = "http://www.w3.org/ns/odrl/2/obligation";
    public static final String ODRL_ASSIGNER_ATTRIBUTE = "http://www.w3.org/ns/odrl/2/assigner";
    public static final String ODRL_TARGET_ATTRIBUTE = "http://www.w3.org/ns/odrl/2/target";
    public static final String ODRL_ASSIGNEE_ATTRIBUTE = "http://www.w3.org/ns/odrl/2/assignee";
    public static final String ODRL_POLICY_TYPE_OFFER = "http://www.w3.org/ns/odrl/2/Offer";
    @JsonProperty(value="@type")
    private final String type = "http://www.w3.org/ns/odrl/2/Offer";
    @JsonProperty(value="@id")
    private final String offerId;
    @JsonProperty(value="http://www.w3.org/ns/odrl/2/permission")
    private final List<Permission> permissions;
    @JsonProperty(value="http://www.w3.org/ns/odrl/2/prohibition")
    private final List<Prohibition> prohibitions;
    @JsonProperty(value="http://www.w3.org/ns/odrl/2/obligation")
    private final List<Duty> obligations;
    @JsonProperty(value="http://www.w3.org/ns/odrl/2/assigner")
    private final String assigner;
    @JsonProperty(value="http://www.w3.org/ns/odrl/2/assignee")
    private final String assignee;
    @JsonProperty(value="http://www.w3.org/ns/odrl/2/target")
    private final String target;

    public static ContractOffer fromPolicy(Policy policy, String offerId, String target, String assigner) {
        return ContractOffer.builder().prohibitions(policy.getProhibitions()).obligations(policy.getObligations()).permissions(policy.getPermissions()).offerId(offerId).target(target).assigner(assigner).build();
    }

    @Generated
    ContractOffer(String offerId, List<Permission> permissions, List<Prohibition> prohibitions, List<Duty> obligations, String assigner, String assignee, String target) {
        this.offerId = offerId;
        this.permissions = permissions;
        this.prohibitions = prohibitions;
        this.obligations = obligations;
        this.assigner = assigner;
        this.assignee = assignee;
        this.target = target;
    }

    @Generated
    public static ContractOfferBuilder builder() {
        return new ContractOfferBuilder();
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getOfferId() {
        return this.offerId;
    }

    @Generated
    public List<Permission> getPermissions() {
        return this.permissions;
    }

    @Generated
    public List<Prohibition> getProhibitions() {
        return this.prohibitions;
    }

    @Generated
    public List<Duty> getObligations() {
        return this.obligations;
    }

    @Generated
    public String getAssigner() {
        return this.assigner;
    }

    @Generated
    public String getAssignee() {
        return this.assignee;
    }

    @Generated
    public String getTarget() {
        return this.target;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContractOffer)) {
            return false;
        }
        ContractOffer other = (ContractOffer)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$offerId = this.getOfferId();
        String other$offerId = other.getOfferId();
        if (this$offerId == null ? other$offerId != null : !this$offerId.equals(other$offerId)) {
            return false;
        }
        List<Permission> this$permissions = this.getPermissions();
        List<Permission> other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        List<Prohibition> this$prohibitions = this.getProhibitions();
        List<Prohibition> other$prohibitions = other.getProhibitions();
        if (this$prohibitions == null ? other$prohibitions != null : !((Object)this$prohibitions).equals(other$prohibitions)) {
            return false;
        }
        List<Duty> this$obligations = this.getObligations();
        List<Duty> other$obligations = other.getObligations();
        if (this$obligations == null ? other$obligations != null : !((Object)this$obligations).equals(other$obligations)) {
            return false;
        }
        String this$assigner = this.getAssigner();
        String other$assigner = other.getAssigner();
        if (this$assigner == null ? other$assigner != null : !this$assigner.equals(other$assigner)) {
            return false;
        }
        String this$assignee = this.getAssignee();
        String other$assignee = other.getAssignee();
        if (this$assignee == null ? other$assignee != null : !this$assignee.equals(other$assignee)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        return !(this$target == null ? other$target != null : !this$target.equals(other$target));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $offerId = this.getOfferId();
        result = result * 59 + ($offerId == null ? 43 : $offerId.hashCode());
        List<Permission> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        List<Prohibition> $prohibitions = this.getProhibitions();
        result = result * 59 + ($prohibitions == null ? 43 : ((Object)$prohibitions).hashCode());
        List<Duty> $obligations = this.getObligations();
        result = result * 59 + ($obligations == null ? 43 : ((Object)$obligations).hashCode());
        String $assigner = this.getAssigner();
        result = result * 59 + ($assigner == null ? 43 : $assigner.hashCode());
        String $assignee = this.getAssignee();
        result = result * 59 + ($assignee == null ? 43 : $assignee.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContractOffer(type=" + this.getType() + ", offerId=" + this.getOfferId() + ", permissions=" + String.valueOf(this.getPermissions()) + ", prohibitions=" + String.valueOf(this.getProhibitions()) + ", obligations=" + String.valueOf(this.getObligations()) + ", assigner=" + this.getAssigner() + ", assignee=" + this.getAssignee() + ", target=" + this.getTarget() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class ContractOfferBuilder {
        @Generated
        private String offerId;
        @Generated
        private ArrayList<Permission> permissions;
        @Generated
        private ArrayList<Prohibition> prohibitions;
        @Generated
        private ArrayList<Duty> obligations;
        @Generated
        private String assigner;
        @Generated
        private String assignee;
        @Generated
        private String target;

        @Generated
        ContractOfferBuilder() {
        }

        @JsonProperty(value="@id")
        @Generated
        public ContractOfferBuilder offerId(String offerId) {
            this.offerId = offerId;
            return this;
        }

        @Generated
        public ContractOfferBuilder permission(Permission permission) {
            if (this.permissions == null) {
                this.permissions = new ArrayList();
            }
            this.permissions.add(permission);
            return this;
        }

        @JsonProperty(value="http://www.w3.org/ns/odrl/2/permission")
        @Generated
        public ContractOfferBuilder permissions(Collection<? extends Permission> permissions) {
            if (permissions == null) {
                throw new NullPointerException("permissions cannot be null");
            }
            if (this.permissions == null) {
                this.permissions = new ArrayList();
            }
            this.permissions.addAll(permissions);
            return this;
        }

        @Generated
        public ContractOfferBuilder clearPermissions() {
            if (this.permissions != null) {
                this.permissions.clear();
            }
            return this;
        }

        @Generated
        public ContractOfferBuilder prohibition(Prohibition prohibition) {
            if (this.prohibitions == null) {
                this.prohibitions = new ArrayList();
            }
            this.prohibitions.add(prohibition);
            return this;
        }

        @JsonProperty(value="http://www.w3.org/ns/odrl/2/prohibition")
        @Generated
        public ContractOfferBuilder prohibitions(Collection<? extends Prohibition> prohibitions) {
            if (prohibitions == null) {
                throw new NullPointerException("prohibitions cannot be null");
            }
            if (this.prohibitions == null) {
                this.prohibitions = new ArrayList();
            }
            this.prohibitions.addAll(prohibitions);
            return this;
        }

        @Generated
        public ContractOfferBuilder clearProhibitions() {
            if (this.prohibitions != null) {
                this.prohibitions.clear();
            }
            return this;
        }

        @Generated
        public ContractOfferBuilder obligation(Duty obligation) {
            if (this.obligations == null) {
                this.obligations = new ArrayList();
            }
            this.obligations.add(obligation);
            return this;
        }

        @JsonProperty(value="http://www.w3.org/ns/odrl/2/obligation")
        @Generated
        public ContractOfferBuilder obligations(Collection<? extends Duty> obligations) {
            if (obligations == null) {
                throw new NullPointerException("obligations cannot be null");
            }
            if (this.obligations == null) {
                this.obligations = new ArrayList();
            }
            this.obligations.addAll(obligations);
            return this;
        }

        @Generated
        public ContractOfferBuilder clearObligations() {
            if (this.obligations != null) {
                this.obligations.clear();
            }
            return this;
        }

        @JsonProperty(value="http://www.w3.org/ns/odrl/2/assigner")
        @Generated
        public ContractOfferBuilder assigner(String assigner) {
            this.assigner = assigner;
            return this;
        }

        @JsonProperty(value="http://www.w3.org/ns/odrl/2/assignee")
        @Generated
        public ContractOfferBuilder assignee(String assignee) {
            this.assignee = assignee;
            return this;
        }

        @JsonProperty(value="http://www.w3.org/ns/odrl/2/target")
        @Generated
        public ContractOfferBuilder target(String target) {
            this.target = target;
            return this;
        }

        @Generated
        public ContractOffer build() {
            return new ContractOffer(this.offerId, switch (this.permissions == null ? 0 : this.permissions.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.permissions.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Permission>(this.permissions));
            }, switch (this.prohibitions == null ? 0 : this.prohibitions.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.prohibitions.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Prohibition>(this.prohibitions));
            }, switch (this.obligations == null ? 0 : this.obligations.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.obligations.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Duty>(this.obligations));
            }, this.assigner, this.assignee, this.target);
        }

        @Generated
        public String toString() {
            return "ContractOffer.ContractOfferBuilder(offerId=" + this.offerId + ", permissions=" + String.valueOf(this.permissions) + ", prohibitions=" + String.valueOf(this.prohibitions) + ", obligations=" + String.valueOf(this.obligations) + ", assigner=" + this.assigner + ", assignee=" + this.assignee + ", target=" + this.target + ")";
        }
    }
}

