/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import lombok.Generated;
import org.eclipse.tractusx.irs.data.StringMapper;

@JsonDeserialize(builder=EDRAuthCodeBuilder.class)
public class EDRAuthCode {
    private final long exp;
    private final String dad;
    private final String cid;

    public static EDRAuthCode fromAuthCodeToken(String token) {
        String[] chunks = token.split("\\.");
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String payload = new String(decoder.decode(chunks[1]), StandardCharsets.UTF_8);
        return (EDRAuthCode)StringMapper.mapFromString((String)payload, EDRAuthCode.class);
    }

    @Generated
    EDRAuthCode(long exp, String dad, String cid) {
        this.exp = exp;
        this.dad = dad;
        this.cid = cid;
    }

    @Generated
    public static EDRAuthCodeBuilder builder() {
        return new EDRAuthCodeBuilder();
    }

    @Generated
    public long getExp() {
        return this.exp;
    }

    @Generated
    public String getDad() {
        return this.dad;
    }

    @Generated
    public String getCid() {
        return this.cid;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EDRAuthCode)) {
            return false;
        }
        EDRAuthCode other = (EDRAuthCode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExp() != other.getExp()) {
            return false;
        }
        String this$dad = this.getDad();
        String other$dad = other.getDad();
        if (this$dad == null ? other$dad != null : !this$dad.equals(other$dad)) {
            return false;
        }
        String this$cid = this.getCid();
        String other$cid = other.getCid();
        return !(this$cid == null ? other$cid != null : !this$cid.equals(other$cid));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EDRAuthCode;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $exp = this.getExp();
        result = result * 59 + (int)($exp >>> 32 ^ $exp);
        String $dad = this.getDad();
        result = result * 59 + ($dad == null ? 43 : $dad.hashCode());
        String $cid = this.getCid();
        result = result * 59 + ($cid == null ? 43 : $cid.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EDRAuthCode(exp=" + this.getExp() + ", dad=" + this.getDad() + ", cid=" + this.getCid() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class EDRAuthCodeBuilder {
        @Generated
        private long exp;
        @Generated
        private String dad;
        @Generated
        private String cid;

        @Generated
        EDRAuthCodeBuilder() {
        }

        @Generated
        public EDRAuthCodeBuilder exp(long exp) {
            this.exp = exp;
            return this;
        }

        @Generated
        public EDRAuthCodeBuilder dad(String dad) {
            this.dad = dad;
            return this;
        }

        @Generated
        public EDRAuthCodeBuilder cid(String cid) {
            this.cid = cid;
            return this;
        }

        @Generated
        public EDRAuthCode build() {
            return new EDRAuthCode(this.exp, this.dad, this.cid);
        }

        @Generated
        public String toString() {
            return "EDRAuthCode.EDRAuthCodeBuilder(exp=" + this.exp + ", dad=" + this.dad + ", cid=" + this.cid + ")";
        }
    }
}

