/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.eclipse.edc.spi.types.domain.callback.CallbackAddress;
import org.eclipse.tractusx.irs.edc.client.model.ContractOffer;

@JsonDeserialize(builder=NegotiationRequestBuilder.class)
public final class NegotiationRequest {
    public static final String NEGOTIATION_COUNTER_PARTY_ADDRESS = "https://w3id.org/edc/v0.0.1/ns/counterPartyAddress";
    public static final String NEGOTIATION_COUNTER_PARTY_ID = "https://w3id.org/edc/v0.0.1/ns/counterPartyId";
    public static final String NEGOTIATION_PROTOCOL = "https://w3id.org/edc/v0.0.1/ns/protocol";
    public static final String NEGOTIATION_CONNECTOR_ID = "https://w3id.org/edc/v0.0.1/ns/connectorId";
    public static final String NEGOTIATION_PROVIDER_ID = "https://w3id.org/edc/v0.0.1/ns/providerId";
    public static final String NEGOTIATION_CONSUMER_ID = "https://w3id.org/edc/v0.0.1/ns/consumerId";
    public static final String NEGOTIATION_OFFER = "https://w3id.org/edc/v0.0.1/ns/offer";
    public static final String NEGOTIATION_CALLBACK_ADDRESSES = "https://w3id.org/edc/v0.0.1/ns/callbackAddresses";
    public static final String NEGOTIATION_OFFER_ID = "https://w3id.org/edc/v0.0.1/ns/offerId";
    public static final String NEGOTIATION_ASSET_ID = "https://w3id.org/edc/v0.0.1/ns/assetId";
    public static final String NEGOTIATION_POLICY = "https://w3id.org/edc/v0.0.1/ns/policy";
    @NotBlank(message="counterPartyAddress is mandatory")
    private final @NotBlank(message="counterPartyAddress is mandatory") String counterPartyAddress;
    @NotBlank(message="counterPartyId is mandatory")
    private final @NotBlank(message="counterPartyId is mandatory") String counterPartyId;
    @NotBlank(message="protocol is mandatory")
    private final @NotBlank(message="protocol is mandatory") String protocol;
    @NotNull(message="offer cannot be null")
    private final @NotNull(message="offer cannot be null") ContractOffer contractOffer;
    private final List<CallbackAddress> callbackAddresses = new ArrayList<CallbackAddress>();

    @Generated
    NegotiationRequest(String counterPartyAddress, String counterPartyId, String protocol, ContractOffer contractOffer) {
        this.counterPartyAddress = counterPartyAddress;
        this.counterPartyId = counterPartyId;
        this.protocol = protocol;
        this.contractOffer = contractOffer;
    }

    @Generated
    public static NegotiationRequestBuilder builder() {
        return new NegotiationRequestBuilder();
    }

    @Generated
    public NegotiationRequestBuilder toBuilder() {
        return new NegotiationRequestBuilder().counterPartyAddress(this.counterPartyAddress).counterPartyId(this.counterPartyId).protocol(this.protocol).contractOffer(this.contractOffer);
    }

    @Generated
    public String getCounterPartyAddress() {
        return this.counterPartyAddress;
    }

    @Generated
    public String getCounterPartyId() {
        return this.counterPartyId;
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public ContractOffer getContractOffer() {
        return this.contractOffer;
    }

    @Generated
    public List<CallbackAddress> getCallbackAddresses() {
        return this.callbackAddresses;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NegotiationRequest)) {
            return false;
        }
        NegotiationRequest other = (NegotiationRequest)o;
        String this$counterPartyAddress = this.getCounterPartyAddress();
        String other$counterPartyAddress = other.getCounterPartyAddress();
        if (this$counterPartyAddress == null ? other$counterPartyAddress != null : !this$counterPartyAddress.equals(other$counterPartyAddress)) {
            return false;
        }
        String this$counterPartyId = this.getCounterPartyId();
        String other$counterPartyId = other.getCounterPartyId();
        if (this$counterPartyId == null ? other$counterPartyId != null : !this$counterPartyId.equals(other$counterPartyId)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        ContractOffer this$contractOffer = this.getContractOffer();
        ContractOffer other$contractOffer = other.getContractOffer();
        if (this$contractOffer == null ? other$contractOffer != null : !((Object)this$contractOffer).equals(other$contractOffer)) {
            return false;
        }
        List<CallbackAddress> this$callbackAddresses = this.getCallbackAddresses();
        List<CallbackAddress> other$callbackAddresses = other.getCallbackAddresses();
        return !(this$callbackAddresses == null ? other$callbackAddresses != null : !((Object)this$callbackAddresses).equals(other$callbackAddresses));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $counterPartyAddress = this.getCounterPartyAddress();
        result = result * 59 + ($counterPartyAddress == null ? 43 : $counterPartyAddress.hashCode());
        String $counterPartyId = this.getCounterPartyId();
        result = result * 59 + ($counterPartyId == null ? 43 : $counterPartyId.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        ContractOffer $contractOffer = this.getContractOffer();
        result = result * 59 + ($contractOffer == null ? 43 : ((Object)$contractOffer).hashCode());
        List<CallbackAddress> $callbackAddresses = this.getCallbackAddresses();
        result = result * 59 + ($callbackAddresses == null ? 43 : ((Object)$callbackAddresses).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NegotiationRequest(counterPartyAddress=" + this.getCounterPartyAddress() + ", counterPartyId=" + this.getCounterPartyId() + ", protocol=" + this.getProtocol() + ", contractOffer=" + String.valueOf(this.getContractOffer()) + ", callbackAddresses=" + String.valueOf(this.getCallbackAddresses()) + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class NegotiationRequestBuilder {
        @Generated
        private String counterPartyAddress;
        @Generated
        private String counterPartyId;
        @Generated
        private String protocol;
        @Generated
        private ContractOffer contractOffer;

        @Generated
        NegotiationRequestBuilder() {
        }

        @Generated
        public NegotiationRequestBuilder counterPartyAddress(String counterPartyAddress) {
            this.counterPartyAddress = counterPartyAddress;
            return this;
        }

        @Generated
        public NegotiationRequestBuilder counterPartyId(String counterPartyId) {
            this.counterPartyId = counterPartyId;
            return this;
        }

        @Generated
        public NegotiationRequestBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Generated
        public NegotiationRequestBuilder contractOffer(ContractOffer contractOffer) {
            this.contractOffer = contractOffer;
            return this;
        }

        @Generated
        public NegotiationRequest build() {
            return new NegotiationRequest(this.counterPartyAddress, this.counterPartyId, this.protocol, this.contractOffer);
        }

        @Generated
        public String toString() {
            return "NegotiationRequest.NegotiationRequestBuilder(counterPartyAddress=" + this.counterPartyAddress + ", counterPartyId=" + this.counterPartyId + ", protocol=" + this.protocol + ", contractOffer=" + String.valueOf(this.contractOffer) + ")";
        }
    }
}

