/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.policy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tractusx.irs.edc.client.policy.AcceptedPolicy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

public interface AcceptedPoliciesProvider {
    public List<AcceptedPolicy> getAcceptedPolicies(String var1);

    @Service
    @ConditionalOnMissingBean(value={AcceptedPoliciesProvider.class}, ignored={DefaultAcceptedPoliciesProvider.class})
    public static class DefaultAcceptedPoliciesProvider
    implements AcceptedPoliciesProvider {
        private final List<AcceptedPolicy> acceptedPolicies = new ArrayList<AcceptedPolicy>();

        @Override
        public List<AcceptedPolicy> getAcceptedPolicies(String bpn) {
            return List.copyOf(this.acceptedPolicies);
        }

        public void addAcceptedPolicies(List<AcceptedPolicy> policies) {
            this.acceptedPolicies.addAll(policies);
        }

        public void removeAcceptedPolicies(List<AcceptedPolicy> policies) {
            this.acceptedPolicies.removeAll(policies);
        }
    }
}

