/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tractusx.irs.edc.client.policy;

import lombok.Generated;
import org.eclipse.edc.policy.model.AtomicConstraint;
import org.eclipse.edc.policy.model.Expression;
import org.eclipse.edc.policy.model.LiteralExpression;
import org.eclipse.edc.policy.model.Operator;

public class AtomicConstraintValidator {
    private AtomicConstraint atomicConstraint;
    private String leftExpressionValue;
    private String rightExpressionValue;
    private Operator expectedOperator;

    public boolean isValid() {
        return this.isExpressionValid(this.atomicConstraint.getLeftExpression(), this.leftExpressionValue) && this.isExpressionValid(this.atomicConstraint.getRightExpression(), this.rightExpressionValue) && this.expectedOperator.equals((Object)this.atomicConstraint.getOperator());
    }

    private boolean isExpressionValid(Expression expression, String value) {
        if (expression instanceof LiteralExpression) {
            LiteralExpression literalExpression = (LiteralExpression)expression;
            return literalExpression.asString().equals(value);
        }
        return false;
    }

    @Generated
    AtomicConstraintValidator(AtomicConstraint atomicConstraint, String leftExpressionValue, String rightExpressionValue, Operator expectedOperator) {
        this.atomicConstraint = atomicConstraint;
        this.leftExpressionValue = leftExpressionValue;
        this.rightExpressionValue = rightExpressionValue;
        this.expectedOperator = expectedOperator;
    }

    @Generated
    public static AtomicConstraintValidatorBuilder builder() {
        return new AtomicConstraintValidatorBuilder();
    }

    @Generated
    public static class AtomicConstraintValidatorBuilder {
        @Generated
        private AtomicConstraint atomicConstraint;
        @Generated
        private String leftExpressionValue;
        @Generated
        private String rightExpressionValue;
        @Generated
        private Operator expectedOperator;

        @Generated
        AtomicConstraintValidatorBuilder() {
        }

        @Generated
        public AtomicConstraintValidatorBuilder atomicConstraint(AtomicConstraint atomicConstraint) {
            this.atomicConstraint = atomicConstraint;
            return this;
        }

        @Generated
        public AtomicConstraintValidatorBuilder leftExpressionValue(String leftExpressionValue) {
            this.leftExpressionValue = leftExpressionValue;
            return this;
        }

        @Generated
        public AtomicConstraintValidatorBuilder rightExpressionValue(String rightExpressionValue) {
            this.rightExpressionValue = rightExpressionValue;
            return this;
        }

        @Generated
        public AtomicConstraintValidatorBuilder expectedOperator(Operator expectedOperator) {
            this.expectedOperator = expectedOperator;
            return this;
        }

        @Generated
        public AtomicConstraintValidator build() {
            return new AtomicConstraintValidator(this.atomicConstraint, this.leftExpressionValue, this.rightExpressionValue, this.expectedOperator);
        }

        @Generated
        public String toString() {
            return "AtomicConstraintValidator.AtomicConstraintValidatorBuilder(atomicConstraint=" + String.valueOf(this.atomicConstraint) + ", leftExpressionValue=" + this.leftExpressionValue + ", rightExpressionValue=" + this.rightExpressionValue + ", expectedOperator=" + String.valueOf(this.expectedOperator) + ")";
        }
    }
}

